/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfValue;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.RunContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.TableRow;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.PdfKey;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.Resolver;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractResolver
implements Resolver {
    private static final Pattern SCHEME_PATTERN = Pattern.compile("^[a-zA-Z0-9\\-+.]+$");
    private final @NonNull String scheme;
    private final @NonNull Set<URI> fonts;

    protected AbstractResolver(@NonNull String scheme) {
        this(scheme, Collections.emptySet());
    }

    protected AbstractResolver(@NonNull String scheme, @NonNull Set<URI> fonts) {
        Objects.requireNonNull(scheme);
        Objects.requireNonNull(fonts);
        if (!SCHEME_PATTERN.matcher(scheme).matches()) {
            throw new IllegalArgumentException("Invalid scheme pattern: " + scheme);
        }
        this.scheme = Objects.requireNonNull(scheme);
        this.fonts = Collections.unmodifiableSet(new HashSet<URI>(fonts));
    }

    @Override
    public @NonNull String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.scheme).toString();
    }

    @Override
    public boolean supports(@NonNull PdfKey pdfKey) {
        return pdfKey.getScheme().equals(this.scheme);
    }

    @Override
    public final @NonNull String getScheme() {
        return this.scheme;
    }

    @Override
    public @NonNull Set<URI> getFonts() {
        return this.fonts;
    }

    @Override
    public @Nullable String formatValue(@NonNull PdfKey pdfKey, @Nullable TableRow tableRow, @NonNull PdfValue resolvedValue, @NonNull RunContext ctx) {
        Object value = resolvedValue.getValue();
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }
}

