/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform;

import ch.dvbern.lib.pdfforms.PdfField;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.RunContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.PdfKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PdfFieldBag {
    private final @NonNull Set<PdfField> fields;
    private final @NonNull Map<LMK, Set<PdfField>> tableFields;

    public PdfFieldBag(@NonNull Set<PdfField> fields, @NonNull Map<LMK, Set<PdfField>> pdfField) {
        this.fields = Collections.unmodifiableSet(Objects.requireNonNull(fields));
        this.tableFields = Collections.unmodifiableMap(Objects.requireNonNull(pdfField));
    }

    public @NonNull Set<LMK> getTableLMKs() {
        return this.tableFields.keySet();
    }

    public Set<LMK> getTableLMKsForParent(DMK parent, Map<String, LogicModelItem> logicModel) {
        LMK parentLmk = Objects.requireNonNull(parent).toLMK();
        HashSet<LMK> entries = new HashSet<LMK>();
        for (LMK lomokey : this.tableFields.keySet()) {
            LMK containingTableLMK = lomokey.findContainingTable(logicModel).map(LogicModelItem::getLMK).orElse(null);
            if (lomokey == null || !parentLmk.equals(containingTableLMK)) continue;
            entries.add(lomokey);
        }
        return entries;
    }

    public @NonNull Set<PdfField> getFieldsForTable(@NonNull LMK tableLMK) {
        Set<PdfField> pdfFields = this.tableFields.get(tableLMK);
        if (pdfFields == null) {
            throw new IllegalArgumentException("Table not defined: " + String.valueOf(tableLMK));
        }
        return pdfFields;
    }

    public @NonNull SortedMap<Integer, Set<PdfField>> getRowsForTable(@NonNull LMK tableLMK, @NonNull RunContext ctx) {
        Set<PdfField> pdfFields = this.tableFields.get(tableLMK);
        TreeMap<Integer, Set<PdfField>> results = new TreeMap<Integer, Set<PdfField>>();
        if (pdfFields == null) {
            return results;
        }
        for (PdfField pdfField : pdfFields) {
            PdfKey pdfKey = PdfKey.parseSimpleUri(pdfField.getName());
            int rowNum = pdfKey.getPdfRow();
            if (!results.containsKey(rowNum)) {
                results.put(rowNum, new HashSet());
            }
            ((Set)results.get(rowNum)).add(pdfField);
        }
        return results;
    }

    public @NonNull Set<PdfField> getFields() {
        return this.fields;
    }

    public @NonNull Map<LMK, Set<PdfField>> getTableFields() {
        return this.tableFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this.fields, this.tableFields);
    }

    @NotThreadSafe
    public static class Builder {
        private final Set<PdfField> fields;
        private final Map<LMK, Set<PdfField>> tableFields;

        private Builder() {
            this.fields = new HashSet<PdfField>();
            this.tableFields = new HashMap<LMK, Set<PdfField>>();
        }

        private Builder(@NonNull Set<PdfField> fields, Map<LMK, Set<PdfField>> tableFields) {
            this.fields = new HashSet<PdfField>(fields);
            this.tableFields = new HashMap<LMK, Set<PdfField>>();
            for (Map.Entry<LMK, Set<PdfField>> entry : tableFields.entrySet()) {
                HashSet values = new HashSet();
                values.addAll(entry.getValue());
                tableFields.put(entry.getKey(), values);
            }
        }

        public static Builder dvbTaxForm() {
            return new Builder();
        }

        public Builder withField(@NonNull PdfField pdfField) {
            this.fields.add(pdfField);
            return this;
        }

        public Builder withTable(@NonNull LMK tableLMK) {
            if (!this.tableFields.containsKey(tableLMK)) {
                this.tableFields.put(tableLMK, new HashSet());
            }
            return this;
        }

        public Builder withTableField(@NonNull LMK tableLMK, @NonNull PdfField pdfField) {
            this.withTable(tableLMK);
            this.tableFields.get(tableLMK).add(pdfField);
            return this;
        }

        public PdfFieldBag build() {
            return new PdfFieldBag(this.fields, this.tableFields);
        }
    }
}

