/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ListAdditionItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ListPrinter
extends ExpertItemPrinter<ExpertDisplayInfoDTO.ItemDTO> {
    private ExpertDisplayInfoDTO.ListDTO item;

    @Override
    protected void initalize(@NonNull ExpertDisplayInfoDTO.ItemDTO newItem) {
        this.item = (ExpertDisplayInfoDTO.ListDTO)newItem;
    }

    @Override
    public void printInternal(float xOffset, float yOffset) throws FormRendererException {
        float top = this.calcUpperRightY(this.item, yOffset);
        float bottom = this.calcLowerLeftY(this.item, yOffset);
        this.printList(xOffset, top, bottom, this.item, 0);
    }

    protected void printList(float xOffset, float top, float bottom, ExpertDisplayInfoDTO.ListDTO list, int start) throws FormRendererException {
        this.item = list;
        float left = this.calcLowerLeftX(this.item, xOffset);
        float right = this.calcUpperRightX(this.item, xOffset);
        for (int i = start; i < this.item.getRows().size(); ++i) {
            if (top - (float)this.item.getRowHeight() < bottom) {
                ExpertDisplayInfoDTO.PageSettingsDTO page = this.getDocumentContext().getPageSettings();
                int height = page.getHeight() - page.getMarginBottom() - page.getMarginTop();
                int y = page.getMarginTop();
                this.addExtraItem(new ListAdditionItem(this.item, i, y, height));
                break;
            }
            ExpertDisplayInfoDTO.ListDTO.RowDTO element = this.item.getRows().get(i);
            String text = this.getText(element);
            top = this.printListMultipleLines(text, element, true, top, bottom, left, right);
        }
    }

    private float printListMultipleLines(String text, ExpertDisplayInfoDTO.ListDTO.RowDTO element, boolean firstLine, float top, float bottom, float left, float right) throws FormRendererException {
        text = firstLine ? element.getListItemChar() + "\t" + (String)text : "\t\t" + (String)text;
        FontDTO fontDTO = this.item.getFont();
        if (element.getFont() != null) {
            fontDTO = element.getFont();
        }
        if (((String)text).length() > this.item.getMaxChars()) {
            String subText = ((String)text).substring(0, this.item.getMaxChars() - 1);
            int index = subText.lastIndexOf(32);
            String thisLine = ((String)text).substring(0, index);
            String nextLine = ((String)text).substring(index + 1);
            this.printText(thisLine, left, top - (float)this.item.getRowHeight(), right, top, fontDTO, 0);
            top -= (float)this.item.getRowHeight();
            top = this.printListMultipleLines(nextLine, element, false, top, bottom, left, right);
        } else {
            this.printText((String)text, left, top - (float)this.item.getRowHeight(), right, top, fontDTO, 0);
            top -= (float)this.item.getRowHeight();
        }
        return top;
    }
}

