/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagePrinter
extends ExpertItemPrinter<ExpertDisplayInfoDTO.ImageDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(ImagePrinter.class);
    private ExpertDisplayInfoDTO.ImageDTO item = null;

    @Override
    protected void initalize(@NonNull ExpertDisplayInfoDTO.ImageDTO item) {
        this.item = item;
    }

    @Override
    public void printInternal(float xOffset, float yOffset) throws FormRendererException {
        String imageFileName = this.item.getFileName();
        if (imageFileName == null) {
            LOG.debug("Skipping image because the file name is empty");
            return;
        }
        try {
            if (imageFileName.toLowerCase().endsWith("pdf")) {
                if (this.item.getPage() > 0) {
                    PdfWriter writer = this.getDocumentContext().getWriter();
                    PdfContentByte cb = writer.getDirectContentUnder();
                    PdfImportedPage page = writer.getImportedPage(this.getReader(), this.item.getPage());
                    if (this.item.getWidth() > this.item.getHeight() && page.getWidth() < page.getHeight()) {
                        cb.addTemplate((PdfTemplate)page, 0.0f, -1.0f, 1.0f, 0.0f, (float)this.item.getX() + xOffset, (float)this.item.getY() + yOffset + page.getWidth());
                    } else {
                        cb.addTemplate((PdfTemplate)page, (float)this.item.getX() + xOffset, (float)this.item.getY() + yOffset);
                    }
                }
            } else {
                Image image = this.getImage();
                image.setAbsolutePosition(this.calcLowerLeftX(this.item, xOffset), this.calcLowerLeftY(this.item, yOffset));
                image.scaleAbsolute((float)this.item.getWidth(), (float)this.item.getHeight());
                this.getDirectContent().addImage(image);
            }
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't add image " + imageFileName + " to document", e);
        }
        catch (IOException e) {
            throw new FormRendererException("can't open image " + imageFileName, e);
        }
        catch (RuntimeException rte) {
            throw new IllegalArgumentException("Cannot create image from file " + imageFileName, rte);
        }
    }

    private Image getImage() throws IOException {
        return Image.getInstance((byte[])this.getImageData());
    }

    private byte[] getImageData() throws IOException {
        ImageSource imgSource = this.getDocumentContext().getImageSource();
        return imgSource.getImage(this.item.getFileName());
    }

    private PdfReader getReader() throws IOException {
        return new PdfReader(this.getImageData());
    }
}

