/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.imports;

import ch.dvbern.tax.common.engine.LogicModelItemInfoDTO;
import ch.dvbern.tax.common.integration.DvbTaxIdentification;
import ch.dvbern.tax.common.presentation.common.imports.ImportConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ImportContext {
    private final @NonNull Map<String, ModelItemDTO> newDataModel;
    private final @NonNull Map<String, ModelItemDTO> oldDataModel;
    private int level;
    private @NonNull String path;
    private final @NonNull ImportConfig config;
    private final @NonNull Map<String, LogicModelItemInfoDTO> logicModelInfoMap;
    private final @Nullable DvbTaxIdentification id;
    private final boolean preInitializedFile;
    private int year;

    public ImportContext(@NonNull Map<String, ModelItemDTO> newDataModel, @NonNull Map<String, ModelItemDTO> oldDataModel, @NonNull ImportConfig config, @NonNull Map<String, LogicModelItemInfoDTO> logicModelInfoMap, @Nullable DvbTaxIdentification id, boolean preInitializedFile) {
        if (logicModelInfoMap == null) {
            throw new NullPointerException("Logic model info map cannot be null.");
        }
        this.newDataModel = newDataModel;
        this.oldDataModel = oldDataModel;
        this.config = config;
        this.path = "";
        this.level = 0;
        this.logicModelInfoMap = logicModelInfoMap;
        this.id = id;
        this.preInitializedFile = preInitializedFile;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public @NonNull String getPath() {
        return this.path;
    }

    public void setPath(@NonNull String path) {
        this.path = path;
    }

    public @NonNull Map<String, ModelItemDTO> getNewDataModel() {
        return this.newDataModel;
    }

    public @NonNull Map<String, ModelItemDTO> getOldDataModel() {
        return this.oldDataModel;
    }

    public @NonNull ImportConfig getConfig() {
        return this.config;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public @NonNull Map<String, LogicModelItemInfoDTO> getLogicModelInfoMap() {
        return this.logicModelInfoMap;
    }

    public @Nullable DvbTaxIdentification getId() {
        return this.id;
    }

    public boolean isPreInitializedFile() {
        return this.preInitializedFile;
    }
}

