/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.integration.util;

import ch.dvbern.tax.common.integration.util.failure.IntegrityConstraintException;
import ch.dvbern.tax.common.integration.util.failure.StorageException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLCall
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SQLCall.class);
    private final @NonNull String sql;
    private final @NonNull List<Object> params = new ArrayList<Object>(20);
    private final @NonNull PreparedStatement stmt;
    private final @NonNull Connection sqlConnection;
    private @Nullable ResultSet result = null;
    private int currentPosition = 1;

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    public SQLCall(@NonNull Connection sqlConnection, @NonNull String statement) {
        this.sqlConnection = sqlConnection;
        try {
            this.sql = statement;
            this.stmt = sqlConnection.prepareStatement(statement);
        }
        catch (SQLException se) {
            try {
                sqlConnection.close();
            }
            catch (SQLException se2) {
                LOG.error("failed to close SQL connection @{}", (Object)statement, (Object)se2);
            }
            throw new StorageException("could not create statement:" + statement, se);
        }
    }

    public void addString(@Nullable String value) {
        try {
            this.params.add(value);
            if (value != null) {
                this.stmt.setString(this.currentPosition++, value);
            } else {
                this.stmt.setNull(this.currentPosition++, 12);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting string at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public void addInt(int value) {
        try {
            this.params.add(value);
            this.stmt.setInt(this.currentPosition++, value);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting string at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public void addInteger(@Nullable Integer value) {
        try {
            this.params.add(value);
            if (value != null) {
                this.stmt.setInt(this.currentPosition++, value);
            } else {
                this.stmt.setNull(this.currentPosition++, 4);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting string at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public void addLong(@Nullable Long value) {
        try {
            this.params.add(value);
            if (value != null) {
                this.stmt.setLong(this.currentPosition++, value);
            } else {
                this.stmt.setNull(this.currentPosition++, -5);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting string at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public void addDoubleObject(@Nullable Double value) {
        try {
            this.params.add(value);
            if (value != null) {
                this.stmt.setDouble(this.currentPosition++, value);
            } else {
                this.stmt.setNull(this.currentPosition++, 8);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting string at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public void addFloatObject(@Nullable Float value) {
        try {
            this.params.add(value);
            if (value != null) {
                this.stmt.setFloat(this.currentPosition++, value.floatValue());
            } else {
                this.stmt.setNull(this.currentPosition++, 6);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting string at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    @Deprecated
    public void addNumber(@Nullable Number value) {
        try {
            this.params.add(value);
            if (value instanceof Integer) {
                this.stmt.setInt(this.currentPosition++, value.intValue());
            } else if (value instanceof Long) {
                this.stmt.setLong(this.currentPosition++, value.longValue());
            } else if (value instanceof Float) {
                this.stmt.setFloat(this.currentPosition++, value.floatValue());
            } else if (value instanceof Double) {
                this.stmt.setDouble(this.currentPosition++, value.doubleValue());
            } else {
                this.stmt.setNull(this.currentPosition++, 8);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting Number at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public void addObject(@Nullable Object value) {
        try {
            this.params.add(value);
            this.stmt.setObject(this.currentPosition++, value);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting object at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public void addDate(Date value) {
        try {
            this.params.add(value);
            if (value != null) {
                Date d = new Date(value.getTime());
                this.stmt.setDate(this.currentPosition++, d);
            } else {
                this.stmt.setNull(this.currentPosition++, 91);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting date at position " + (this.currentPosition - 1) + " value=" + String.valueOf(value) + " @" + this.dumpSql(), se);
        }
    }

    public void addTimestamp(@Nullable java.util.Date dateTime) {
        try {
            this.params.add(dateTime);
            if (dateTime != null) {
                Timestamp t = new Timestamp(dateTime.getTime());
                this.stmt.setTimestamp(this.currentPosition++, t);
            } else {
                this.stmt.setNull(this.currentPosition++, 93);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting date at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public void addDouble(double value) {
        try {
            this.params.add(value);
            this.stmt.setDouble(this.currentPosition++, value);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting double at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public void addBigDecimal(@Nullable BigDecimal value) {
        try {
            this.params.add(value);
            this.stmt.setBigDecimal(this.currentPosition++, value);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting bigdecimal at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public void addBoolean(boolean value) {
        try {
            this.params.add(value);
            String s = value ? "1" : "0";
            this.stmt.setString(this.currentPosition++, s);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting boolean at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public void addBooleanObject(@Nullable Boolean value) {
        this.params.add(value);
        if (value == null) {
            try {
                this.stmt.setNull(this.currentPosition++, 12);
            }
            catch (SQLException se) {
                this.cleanup();
                throw new StorageException("exception while setting boolean at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
            }
        } else {
            this.addBoolean(value);
        }
    }

    public void addBytes(byte[] value) {
        this.params.add("[" + (value == null ? "null" : String.valueOf(value.length)) + "]");
        try {
            if (value == null) {
                this.stmt.setNull(this.currentPosition++, 2004);
            } else {
                this.stmt.setBytes(this.currentPosition++, value);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting bindary data at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public void addBinaryStream(@Nullable InputStream value) {
        this.params.add("[BinaryStream:" + (value == null ? "null" : String.valueOf(value)) + "]");
        try {
            if (value == null) {
                this.stmt.setNull(this.currentPosition++, 2004);
            } else {
                this.stmt.setBinaryStream(this.currentPosition++, value);
            }
        }
        catch (SQLException e) {
            this.cleanup();
            throw new StorageException("exception while setting binarystream at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), e);
        }
    }

    public void addBinaryStream(@Nullable InputStream value, long length) {
        this.params.add("[BinaryStream:" + (String)(value == null ? "null" : String.valueOf(length) + "/" + length + "]"));
        try {
            if (value == null) {
                this.stmt.setNull(this.currentPosition++, 2004);
            } else {
                this.stmt.setBinaryStream(this.currentPosition++, value, length);
            }
        }
        catch (SQLException e) {
            this.cleanup();
            throw new StorageException("exception while setting binarystream(" + length + ") at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), e);
        }
    }

    public void addBlob(@Nullable Blob value) {
        this.params.add("[Blob:" + (value == null ? "null" : String.valueOf(value)) + "]");
        try {
            if (value == null) {
                this.stmt.setNull(this.currentPosition++, 2004);
            } else {
                this.stmt.setBlob(this.currentPosition++, value);
            }
        }
        catch (SQLException e) {
            this.cleanup();
            throw new StorageException("exception while setting blob at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), e);
        }
    }

    public void addBlob(@Nullable InputStream value) {
        this.params.add("[Blob/Inputstream:" + (value == null ? "null" : String.valueOf(value)) + "]");
        try {
            if (value == null) {
                this.stmt.setNull(this.currentPosition++, 2004);
            } else {
                this.stmt.setBlob(this.currentPosition++, value);
            }
        }
        catch (SQLException e) {
            this.cleanup();
            throw new StorageException("exception while setting blob/inputstream at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), e);
        }
    }

    public void addBlob(@Nullable InputStream value, long length) {
        this.params.add("[Blob/Inputstream:" + (value == null ? "null" : String.valueOf(value)) + "/" + length + "]");
        try {
            if (value == null) {
                this.stmt.setNull(this.currentPosition++, 2004);
            } else {
                this.stmt.setBlob(this.currentPosition++, value, length);
            }
        }
        catch (SQLException e) {
            this.cleanup();
            throw new StorageException("exception while setting blob/inputstream at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), e);
        }
    }

    public int executeDelete() throws IntegrityConstraintException {
        try {
            return this.stmt.executeUpdate();
        }
        catch (SQLException se) {
            String sqlState = se.getSQLState();
            if ("23000".equals(sqlState)) {
                throw new IntegrityConstraintException("data can not be removed for @" + this.sql, se);
            }
            throw new StorageException("exception while executing update for @" + this.sql, se);
        }
    }

    public int executeUpdate() {
        try {
            return this.stmt.executeUpdate();
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while executing executeUpdate() @" + this.dumpSql(), se);
        }
    }

    public void executeSelect() {
        try {
            this.result = this.stmt.executeQuery();
            this.currentPosition = 1;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while executing executeSelect() @" + this.dumpSql(), se);
        }
    }

    public boolean next() {
        assert (this.result != null);
        try {
            boolean next = this.result.next();
            if (!next) {
                this.cleanup();
            }
            this.currentPosition = 1;
            return next;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while executing next() @" + this.dumpSql(), se);
        }
    }

    public @NonNull List<Object> getLine() {
        assert (this.result != null);
        try {
            int cols = this.result.getMetaData().getColumnCount();
            ArrayList<Object> ret = new ArrayList<Object>(cols);
            for (int i = 1; i < cols + 1; ++i) {
                ret.add(this.result.getObject(i));
            }
            return ret;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while retreiving objects @" + this.dumpSql(), se);
        }
    }

    public @Nullable String getString() {
        assert (this.result != null);
        try {
            String s = this.result.getString(this.currentPosition++);
            return s == null ? null : s.trim();
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting string at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable String getString(@NonNull String name) {
        assert (this.result != null);
        try {
            String s = this.result.getString(name);
            return s == null ? null : s.trim();
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting string with columnname " + name + " @" + this.dumpSql(), se);
        }
    }

    public @NonNull String getRequiredString(String text) {
        return Objects.requireNonNull(this.getString(text));
    }

    public int getInt() {
        assert (this.result != null);
        try {
            return this.result.getInt(this.currentPosition++);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting int at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public int getInt(@Nullable String name) {
        assert (this.result != null);
        try {
            return this.result.getInt(name);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting int with columnname " + name + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable Integer getInteger() {
        assert (this.result != null);
        try {
            int res = this.result.getInt(this.currentPosition++);
            if (!this.result.wasNull()) {
                return res;
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting int at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable Integer getInteger(@NonNull String name) {
        assert (this.result != null);
        try {
            int res = this.result.getInt(name);
            if (!this.result.wasNull()) {
                return res;
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting int with columnname " + name + " @" + this.dumpSql(), se);
        }
    }

    public @NonNull Integer getRequiredInteger(@NonNull String name) {
        return Objects.requireNonNull(this.getInteger(name));
    }

    public @Nullable Long getLong() {
        assert (this.result != null);
        try {
            long res = this.result.getLong(this.currentPosition++);
            if (!this.result.wasNull()) {
                return res;
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting int at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable Long getLong(@NonNull String name) {
        assert (this.result != null);
        try {
            long res = this.result.getLong(name);
            if (!this.result.wasNull()) {
                return res;
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting int with columnname " + name + " @" + this.dumpSql(), se);
        }
    }

    public @NonNull Long getRequiredLong(@NonNull String name) {
        return Objects.requireNonNull(this.getLong(name));
    }

    public @Nullable Float getFloatObject() {
        assert (this.result != null);
        try {
            double res = this.result.getDouble(this.currentPosition++);
            if (!this.result.wasNull()) {
                return Float.valueOf((float)res);
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting float at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable Float getFloatObject(@NonNull String name) {
        assert (this.result != null);
        try {
            double res = this.result.getDouble(name);
            if (!this.result.wasNull()) {
                return Float.valueOf((float)res);
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting float with columnname " + name + " @" + this.dumpSql(), se);
        }
    }

    public @NonNull Float getRequiredFloatObject(@NonNull String name) {
        return Objects.requireNonNull(this.getFloatObject(name));
    }

    public @Nullable Double getDoubleObject() {
        assert (this.result != null);
        try {
            double res = this.result.getDouble(this.currentPosition++);
            if (!this.result.wasNull()) {
                return res;
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting double at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable Double getDoubleObject(@NonNull String name) {
        assert (this.result != null);
        try {
            double res = this.result.getDouble(name);
            if (!this.result.wasNull()) {
                return res;
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting double with columnname " + name + " @" + this.dumpSql(), se);
        }
    }

    public @NonNull Double getRequiredDoubleObject(@NonNull String name) {
        return Objects.requireNonNull(this.getDoubleObject(name));
    }

    public Date getDate() {
        assert (this.result != null);
        try {
            Date res = this.result.getDate(this.currentPosition++);
            if (res == null) {
                return null;
            }
            return new Date(res.getTime());
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting date at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public Date getDate(@NonNull String name) {
        assert (this.result != null);
        try {
            Date res = this.result.getDate(name);
            if (res == null) {
                return null;
            }
            return new Date(res.getTime());
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting date with columnname " + name + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable Boolean getBooleanObject() {
        assert (this.result != null);
        try {
            if ("1".equals(this.result.getString(this.currentPosition++))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting date at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable Boolean getBooleanObject(@NonNull String name) {
        assert (this.result != null);
        try {
            if ("1".equals(this.result.getString(name))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting date with columnname " + name + " @" + this.dumpSql(), se);
        }
    }

    public @NonNull Boolean getRequiredBooleanObject(@NonNull String name) {
        return Objects.requireNonNull(this.getBooleanObject(name));
    }

    public @Nullable Object getObject() {
        assert (this.result != null);
        try {
            return this.result.getObject(this.currentPosition++);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting object at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable Object getObject(@NonNull String name) {
        assert (this.result != null);
        try {
            return this.result.getObject(name);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting object with columnname " + name + " @" + this.dumpSql(), se);
        }
    }

    public @NonNull Object getRequiredObject(@NonNull String name) {
        return Objects.requireNonNull(this.getObject(name));
    }

    public @Nullable java.util.Date getTimestamp() {
        assert (this.result != null);
        try {
            Timestamp res = this.result.getTimestamp(this.currentPosition++);
            if (res == null) {
                return null;
            }
            return new java.util.Date(res.getTime());
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting date at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable java.util.Date getTimestamp(@NonNull String name) {
        assert (this.result != null);
        try {
            Timestamp res = this.result.getTimestamp(name);
            if (res == null) {
                return null;
            }
            return new java.util.Date(res.getTime());
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting date with columnname " + name + " @" + this.dumpSql(), se);
        }
    }

    public @NonNull java.util.Date getRequiredTimestamp(@NonNull String name) {
        return Objects.requireNonNull(this.getTimestamp(name));
    }

    public float getFloat() {
        assert (this.result != null);
        try {
            return this.result.getFloat(this.currentPosition++);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting float at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public float getFloat(@NonNull String name) {
        assert (this.result != null);
        try {
            return this.result.getFloat(name);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting float with columnname " + name + " @" + this.dumpSql(), se);
        }
    }

    public double getDouble() {
        assert (this.result != null);
        try {
            return this.result.getDouble(this.currentPosition++);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting double at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public double getDouble(@NonNull String name) {
        assert (this.result != null);
        try {
            return this.result.getDouble(name);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting double with columnname " + name + " @" + this.dumpSql(), se);
        }
    }

    public boolean getBoolean() {
        assert (this.result != null);
        try {
            return "1".equals(this.result.getString(this.currentPosition++));
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting boolean at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public boolean getBoolean(@NonNull String name) {
        assert (this.result != null);
        try {
            return "1".equals(this.result.getString(name));
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting boolean with columnname " + name + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable byte[] getBytes() {
        assert (this.result != null);
        try {
            return this.result.getBytes(this.currentPosition++);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting binary data at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable byte[] getBytes(@NonNull String name) {
        assert (this.result != null);
        try {
            return this.result.getBytes(name);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting binary data for name " + name + " @" + this.dumpSql(), se);
        }
    }

    public @NonNull byte[] getRequiredBytes(@NonNull String name) {
        return Objects.requireNonNull(this.getBytes(name));
    }

    public @Nullable Blob getBlob() {
        assert (this.result != null);
        try {
            return this.result.getBlob(this.currentPosition++);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting blob data at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable Blob getBlob(@NonNull String name) {
        assert (this.result != null);
        try {
            return this.result.getBlob(name);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting blob data for name " + name + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable Blob getRequiredBlob(@NonNull String name) {
        return Objects.requireNonNull(this.getBlob(name));
    }

    public @Nullable InputStream getBinaryStream() {
        assert (this.result != null);
        try {
            return this.result.getBinaryStream(this.currentPosition++);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting binary stream at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable InputStream getBinaryStream(@NonNull String name) {
        assert (this.result != null);
        try {
            return this.result.getBinaryStream(name);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting binary stream for name " + name + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable InputStream getRequiredBinaryStream(@NonNull String name) {
        return this.getBinaryStream(name);
    }

    public @Nullable BigDecimal getBigDecimal() {
        assert (this.result != null);
        try {
            return this.result.getBigDecimal(this.currentPosition++);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting bigdecimal at position " + (this.currentPosition - 1) + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable BigDecimal getBigDecimal(@NonNull String name) {
        assert (this.result != null);
        try {
            return this.result.getBigDecimal(name);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting bigdecimal with columnname " + name + " @" + this.dumpSql(), se);
        }
    }

    public @Nullable BigDecimal getRequiredBigDecimal(@NonNull String name) {
        return Objects.requireNonNull(this.getBigDecimal(name));
    }

    public boolean wasNull() {
        assert (this.result != null);
        try {
            return this.result.wasNull();
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while testing on null " + this.currentPosition + " @" + this.dumpSql(), se);
        }
    }

    private void cleanup() {
        block7: {
            try {
                if (this.sqlConnection.isClosed()) break block7;
                if (this.result != null) {
                    try {
                        this.result.close();
                        this.result = null;
                    }
                    catch (SQLException se) {
                        LOG.error("failed to release resources of resource set: {}@{}", new Object[]{this.result, this.dumpSql(), se});
                    }
                }
                try {
                    this.stmt.close();
                }
                catch (SQLException se) {
                    LOG.error("failed to release resources of prepared statement: {}@{}", new Object[]{this.stmt, this.dumpSql(), se});
                }
            }
            catch (SQLException se) {
                LOG.error("SQL cleanup failed @{}", (Object)this.dumpSql(), (Object)se);
                throw new RuntimeException(se);
            }
        }
    }

    private String dumpSql() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sql);
        sb.append(" params:(");
        for (int i = 0; i < this.params.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            String str = String.valueOf(this.params.get(i));
            sb.append('(').append(str, 0, Math.min(str.length(), 300)).append(')');
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public void close() {
        this.cleanup();
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        catch (RuntimeException rte) {
            LOG.error("Error on cleanup in finalizer! @{}", (Object)this.sql, (Object)rte);
        }
        super.finalize();
    }
}

