/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.integration.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public final class ModelUtil {
    public static final Charset DEFAULT_MODEL_CHARSET = Charset.forName("UTF-8");

    private ModelUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getModelContent(InputStream modelInputStream, boolean gzipped, Charset charset) throws IOException {
        String string;
        FilterInputStream input = null;
        ByteArrayOutputStream baos = null;
        try {
            input = gzipped ? new GZIPInputStream(new BufferedInputStream(modelInputStream)) : new BufferedInputStream(modelInputStream);
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            int read = ((InputStream)input).read(buffer);
            while (read >= 0) {
                baos.write(buffer, 0, read);
                read = ((InputStream)input).read(buffer);
            }
            string = new String(baos.toByteArray(), charset);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(baos);
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)baos);
        IOUtils.closeQuietly((InputStream)input);
        return string;
    }
}

