/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.integration.util;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.failure.EmailSendingException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.codemonkey.simplejavamail.Email;
import org.codemonkey.simplejavamail.MailException;
import org.codemonkey.simplejavamail.Mailer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MailHelper.class);
    private static final String MAIL_TRANSPORT_PROTOCOL_PROPERTY_KEY = "mail.transport.protocol";
    private static final String MAIL_SMTP_HOST_PROPERTY_KEY = "mail.smtp.host";
    private static final String MAIL_SMTP_PORT_PROPERTY_KEY = "mail.smtp.port";
    private static final String MAIL_SMTP_USER_PROPERTY_KEY = "mail.smtp.user";
    private static final String MAIL_SMTP_PASSWORD_PROPERTY_KEY = "mail.smtp.password";
    private static final String MAIL_SENDER_NAME_PROPERTY_KEY = "mail.confirmation.sender.name";
    private static final String MAIL_SENDER_ADDRESS_PROPERTY_KEY = "mail.confirmation.sender.address";
    private final String protocol;
    private final String host;
    private final String port;
    private String user;
    private String password;
    private String senderName;
    private String senderAddress;

    public MailHelper() {
        ApplicationConfig config = ApplicationConfig.getInstance();
        this.protocol = config.getMailTransportProtocol();
        this.host = config.getMailSmtpHost();
        this.port = config.getMailSmtpPort();
        this.user = config.getMailSmtpUser();
        this.password = config.getMailSmtpPassword();
        this.senderName = config.getMailSenderName();
        this.senderAddress = config.getMailSenderAdress();
    }

    public MailHelper(String protocol, String host, String port) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    public MailHelper(String protocol, String host, String port, String user, String password) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
    }

    public void setFromTaxme(Email email) {
        email.setFromAddress(this.senderName, this.senderAddress);
    }

    public void sendMail(Email email) {
        try {
            Session session = this.createSession();
            if (session == null) {
                String message = "could not create session to send mail";
                LOG.warn("could not create session to send mail");
                throw new EmailSendingException("could not create session to send mail");
            }
            Mailer mailer = new Mailer(this.host, Integer.valueOf(Integer.parseInt(this.port)), this.user, this.password);
            mailer.sendMail(email);
        }
        catch (NumberFormatException e) {
            String message = "error in converting number (port)";
            LOG.warn("error in converting number (port)", (Throwable)e);
            throw new EmailSendingException("error in converting number (port)", e);
        }
        catch (MailException e) {
            String message = "error in sending mail";
            LOG.warn("error in sending mail", (Throwable)e);
            throw new EmailSendingException("error in sending mail", e);
        }
    }

    public int sendMail(String fromAddress, String toAddress, String subject, String content) {
        return this.sendMail(fromAddress, toAddress, null, null, subject, content);
    }

    public int sendMail(String fromAddress, String toAddress, String ccAddress, String bccAddress, String subject, String content) {
        try {
            Session session = this.createSession();
            if (session == null) {
                LOG.warn("could not create session to send mail");
                return Status.FAILURE.getCode();
            }
            MimeMessage msg = new MimeMessage(session);
            if (fromAddress != null) {
                msg.setFrom((Address)new InternetAddress(fromAddress));
            } else {
                msg.setFrom();
            }
            try {
                msg.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)toAddress, (boolean)false));
            }
            catch (AddressException ae) {
                LOG.warn("mail recipients could not be set", (Throwable)ae);
                return Status.FAILURE.getCode();
            }
            if (ccAddress != null) {
                msg.addRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)ccAddress, (boolean)false));
            }
            if (bccAddress != null) {
                msg.addRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bccAddress, (boolean)false));
            }
            msg.setSubject(MailHelper.encodeMailString(subject));
            msg.setContent((Object)content, "text/plain;charset=iso-8859-1");
            msg.setSentDate(new Date());
            try {
                Transport.send((Message)msg);
                return Status.OK.getCode();
            }
            catch (SendFailedException sfe) {
                String invalidAdressesAsString = Arrays.toString(sfe.getInvalidAddresses());
                LOG.warn("Invalid receiver address specified '" + invalidAdressesAsString + "'", (Throwable)sfe);
                return Status.FAILURE.getCode();
            }
        }
        catch (MessagingException ex) {
            LOG.warn("error in sending mail", (Throwable)ex);
            return Status.FAILURE.getCode();
        }
    }

    private Session createSession() {
        Session session;
        Properties props = new Properties();
        if (this.protocol != null) {
            props.put(MAIL_TRANSPORT_PROTOCOL_PROPERTY_KEY, this.protocol);
        }
        if (this.host == null) {
            LOG.warn("Unable to send mail, because mail host not specified.");
            return null;
        }
        props.put(MAIL_SMTP_HOST_PROPERTY_KEY, this.host);
        if (this.port != null) {
            props.put(MAIL_SMTP_PORT_PROPERTY_KEY, this.port);
        }
        if (this.user != null) {
            props.put(MAIL_SMTP_USER_PROPERTY_KEY, this.user);
        }
        if (this.password != null) {
            props.put(MAIL_SMTP_PASSWORD_PROPERTY_KEY, this.password);
        }
        if (this.senderAddress != null) {
            props.put(MAIL_SENDER_ADDRESS_PROPERTY_KEY, this.senderAddress);
        }
        if (this.senderName != null) {
            props.put(MAIL_SENDER_NAME_PROPERTY_KEY, this.senderName);
        }
        if ((session = Session.getInstance((Properties)props, null)) == null) {
            LOG.warn("Unable to send mail, because of invalid session object.");
            return null;
        }
        session.setDebug(false);
        return session;
    }

    private static String encodeMailString(String text) {
        if (text != null) {
            try {
                text = MimeUtility.encodeText((String)text, (String)"iso-8859-1", null);
            }
            catch (UnsupportedEncodingException uex) {
                LOG.warn("could not encode mail string", (Throwable)uex);
            }
        }
        return text;
    }

    public static enum Status {
        OK(1),
        FAILURE(2);

        private int code;

        private Status(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

