/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.SpannableItem;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StateIndicator
extends WizardDisplayModelItem
implements SpannableItem {
    private final int colspan;
    private final @NonNull LMK stateLMK;
    private final @Nullable String align;
    private final @Nullable String style;
    private final @Nullable String styleClass;

    public StateIndicator(@NonNull LMK state, int colspan, @Nullable String align, @Nullable String style, @Nullable String styleClass) {
        this.stateLMK = Objects.requireNonNull(state);
        this.colspan = colspan;
        this.align = align;
        this.style = style;
        this.styleClass = styleClass;
    }

    public @Nullable List<WizardDisplayModelItem> getChildren() {
        return null;
    }

    @Override
    public int getColspan() {
        return this.colspan;
    }

    @Override
    public void additionalInitializeWizardDisplayModel(Map<String, LogicModelItem> logicModel) {
    }

    @Override
    public WizardDisplayInfoDTO.StateIndicatorItemDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        DMK dmk = DMK.parse(key);
        Row row = (Row)this.getParent();
        int index = row.getIndex(this);
        int width = 0;
        boolean isWidthUndefined = false;
        int corrColspan = this.colspan;
        int colDefState = 11;
        block4: for (int i = 0; i < this.colspan; ++i) {
            int colDefIndex = index + i;
            List<ColDef> colDefs = ((Section)row.getParent()).getColdefs();
            if (colDefIndex >= colDefs.size()) {
                throw new IllegalArgumentException("colDefIndex(" + index + "+" + i + "=" + colDefIndex + ") > number of coldefs(" + colDefs.size() + ") for label with name: " + String.valueOf(this.stateLMK));
            }
            ColDef coldef = colDefs.get(colDefIndex);
            WizardDisplayInfoDTO.ColDefItemDTO cdiDTO = coldef.getFormInfo(dataModel, dmk.toExternalForm());
            if (12 != cdiDTO.getState()) {
                if (!cdiDTO.isWidthUndefined() && !isWidthUndefined) {
                    width += Integer.parseInt(cdiDTO.getWidth());
                } else {
                    width = 0;
                    isWidthUndefined = true;
                }
            }
            switch (cdiDTO.getState()) {
                case 12: {
                    --corrColspan;
                    continue block4;
                }
                case 11: {
                    continue block4;
                }
                default: {
                    colDefState = 1;
                }
            }
        }
        DMK valueDMK = dmk.merge(this.stateLMK);
        ModelItemDTO stateRef = dataModel.getModelItem(valueDMK);
        int state = stateRef.getState();
        if (colDefState == 11) {
            state = 11;
        }
        if (corrColspan <= 0) {
            return null;
        }
        return new WizardDisplayInfoDTO.StateIndicatorItemDTO(this.getUniqueItemIdentifier(), state, key, corrColspan, width, this.align, this.style, this.styleClass);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            int colspan = element.getAttribute("colspan") != null ? Integer.parseInt(element.getAttributeValue("colspan")) : 1;
            return new ClassObjectPair(StateIndicator.class, (Object)new StateIndicator(LMK.parse(element.getAttributeValue("state")), colspan, element.getAttribute("align"), element.getAttributeValue("style"), element.getAttributeValue("styleClass")));
        }
    }
}

