/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.wizarddisplay.SpannableItem;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Form;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Link
extends WizardDisplayModelItem
implements SpannableItem {
    private static final Logger LOG = LoggerFactory.getLogger(Link.class);
    private final int colspan;
    private final String uri;
    private final String name;
    private final String target;
    private final String styleClass;
    private final boolean transparentIfView;
    private final List<LabelAddOn> listAddOns;

    public Link(String uri, String name, String target, int colspan, boolean transparentIfView, String styleClass, List<LabelAddOn> labelAddOns) {
        this.uri = uri;
        this.name = name;
        this.target = target;
        this.colspan = colspan;
        this.transparentIfView = transparentIfView;
        this.styleClass = styleClass;
        this.listAddOns = labelAddOns;
        LOG.debug("LINK: uri=" + uri + ", label=" + name + ", target=" + target + ", styleClass=" + styleClass);
    }

    public List<WizardDisplayModelItem> getChildren() {
        return null;
    }

    @Override
    public int getColspan() {
        return this.colspan;
    }

    @Override
    public WizardDisplayInfoDTO.LinkItemDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO> labelAddOnDTOs = new ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO>();
        if (this.listAddOns != null) {
            for (LabelAddOn element : this.listAddOns) {
                WizardDisplayInfoDTO.LabelAddOnDTO formInfo = element.getFormInfo(dataModel, key);
                if (formInfo == null) continue;
                labelAddOnDTOs.add(formInfo);
            }
        }
        if (labelAddOnDTOs.isEmpty()) {
            labelAddOnDTOs = null;
        }
        if (this.getParent() instanceof Form) {
            return new WizardDisplayInfoDTO.LinkItemDTO(this.getUniqueItemIdentifier(), this.uri, this.name, this.target, this.colspan, this.transparentIfView, this.styleClass, labelAddOnDTOs);
        }
        Row row = (Row)this.getParent();
        int index = row.getIndex(this);
        int corrColspan = this.colspan;
        for (int i = 0; i < this.colspan; ++i) {
            ColDef coldef = ((Section)row.getParent()).getColdefs().get(index + i);
            WizardDisplayInfoDTO.ColDefItemDTO cdiDTO = coldef.getFormInfo(dataModel, key);
            if (cdiDTO.getState() != 12) continue;
            --corrColspan;
        }
        if (corrColspan <= 0) {
            return null;
        }
        return new WizardDisplayInfoDTO.LinkItemDTO(this.getUniqueItemIdentifier(), this.uri, this.name, this.target, corrColspan, this.transparentIfView, this.styleClass, labelAddOnDTOs);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<LabelAddOn> labelAddOns = new ArrayList<LabelAddOn>();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LabelAddOn) {
                        labelAddOns.add((LabelAddOn)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            String uri = element.getAttributeValue("URI");
            if (uri == null || uri.isEmpty()) {
                throw new ElementParserException("missing URI argument for " + String.valueOf(element));
            }
            int colspan = element.getAttribute("colspan") != null ? Integer.parseInt(element.getAttributeValue("colspan")) : 1;
            boolean transparentIfEdit = false;
            if (element.getAttribute("transparent-if-view") != null) {
                transparentIfEdit = Boolean.valueOf(element.getAttributeValue("transparent-if-view"));
            }
            return new ClassObjectPair(Link.class, (Object)new Link(uri, element.getAttributeValue("name"), element.getAttributeValue("target"), colspan, transparentIfEdit, element.getAttributeValue("styleClass"), labelAddOns));
        }
    }
}

