/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Form;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Label;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Table;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Help
extends WizardDisplayModelItem {
    private static final Logger LOG = LoggerFactory.getLogger(Help.class);
    private final String id;

    public Help(String id) {
        this.id = id;
    }

    public @Nullable List<WizardDisplayModelItem> getChildren() {
        return null;
    }

    @Override
    public WizardDisplayInfoDTO.HelpItemDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        String helpMessageKey = null;
        WizardDisplayModelItem parentItem = this.getParent();
        WizardDisplayInfoDTO.HelpItemDTO.HelpParent helpParent = WizardDisplayInfoDTO.HelpItemDTO.HelpParent.OTHER;
        if (parentItem instanceof Section) {
            helpMessageKey = ((Section)parentItem).getHeader();
            helpParent = WizardDisplayInfoDTO.HelpItemDTO.HelpParent.SECTION;
        } else if (parentItem instanceof Table) {
            helpMessageKey = ((Table)parentItem).getHeader();
            helpParent = WizardDisplayInfoDTO.HelpItemDTO.HelpParent.TABLE;
        } else if (parentItem instanceof Form) {
            helpMessageKey = ((Form)parentItem).getHeader();
            helpParent = WizardDisplayInfoDTO.HelpItemDTO.HelpParent.FORM;
        } else if (parentItem instanceof Label) {
            helpMessageKey = null;
            helpParent = WizardDisplayInfoDTO.HelpItemDTO.HelpParent.LABEL;
        } else {
            LOG.debug("help {}, parentItem: {}", (Object)key, (Object)(parentItem == null ? "(null)" : parentItem.getClass().getName()));
        }
        return new WizardDisplayInfoDTO.HelpItemDTO(this.getUniqueItemIdentifier(), 1, this.id, helpMessageKey, helpParent);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            if (!elements.isEmpty()) {
                throw new ElementParserException("invalid child type for " + String.valueOf(element));
            }
            return new ClassObjectPair(Help.class, (Object)new Help(element.getAttributeValue("id")));
        }
    }
}

