/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay;

import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Form;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.PersistenceWriteDTO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class WizardDisplayModelItem {
    private WizardDisplayModelItem parent;
    private DisplayItemUniqueID uniqueItemIdentifier;

    public abstract Object getFormInfo(ProtectedMap var1, String var2);

    public WizardDisplayModelItem getParent() {
        return this.parent;
    }

    public void setParent(WizardDisplayModelItem parent) {
        this.parent = parent;
    }

    public abstract @Nullable List<? extends WizardDisplayModelItem> getChildren();

    protected DisplayItemUniqueID getUniqueItemIdentifier() {
        return this.uniqueItemIdentifier;
    }

    protected Form findContainingForm() {
        WizardDisplayModelItem wdmi;
        int emergencyBrake = 1000;
        for (wdmi = this; wdmi != null && !(wdmi instanceof Form) && --emergencyBrake > 0; wdmi = wdmi.getParent()) {
        }
        assert (emergencyBrake > 0);
        assert (wdmi instanceof Form);
        return (Form)wdmi;
    }

    protected DisplayItemUniqueID createUniqueId() {
        return new DisplayItemUniqueID(this.findContainingForm().getName(), this.findContainingForm().nextGUIItemUniqueId());
    }

    public final void initializeWizardDisplayModel(Map<String, LogicModelItem> logicModelItems, Map<String, Form> wizardDisplayModel) throws InvalidModelException {
        this.uniqueItemIdentifier = this.createUniqueId();
        if (this.getChildren() != null) {
            for (WizardDisplayModelItem wizardDisplayModelItem : this.getChildren()) {
                wizardDisplayModelItem.initializeWizardDisplayModel(logicModelItems, wizardDisplayModel);
            }
        }
        this.additionalInitializeWizardDisplayModel(logicModelItems);
    }

    protected void additionalInitializeWizardDisplayModel(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
    }

    public static class ProtectedMap
    extends LogicModelItem.ProtectedMap {
        private final Engine engine;
        private final boolean writeOnView;

        public ProtectedMap(Map<String, ModelItemDTO> nestedMap, boolean writeOnView, Engine engine) {
            super(nestedMap, true);
            this.writeOnView = writeOnView;
            this.engine = engine;
        }

        @Deprecated
        public @NonNull ModelItemDTO getModelItem(@NonNull String key) {
            ModelItemDTO modelItemDTO = (ModelItemDTO)this.nestedMap.get(key);
            if (modelItemDTO == null) {
                modelItemDTO = new ModelItemDTO(null, 3);
            }
            if (!modelItemDTO.isTouched() && this.writeOnView) {
                modelItemDTO = modelItemDTO.clone(modelItemDTO.getValue());
                modelItemDTO.setTouched();
                HashMap<String, ModelItemDTO> changes = new HashMap<String, ModelItemDTO>();
                changes.put(key, modelItemDTO);
                Map<String, List<PersistenceWriteDTO>> result = this.engine.update(this.nestedMap, changes, true).getPersistenceWriteDTOs();
                this.getChangedMap().putAll(result);
            }
            return modelItemDTO;
        }

        public @NonNull ModelItemDTO getModelItem(@NonNull DMK dmk) {
            return this.getModelItem(dmk.toExternalForm());
        }

        public void touch(String key) {
            ModelItemDTO modelItemDTO = (ModelItemDTO)this.nestedMap.get(key);
            if (modelItemDTO == null) {
                modelItemDTO = new ModelItemDTO(null, 1);
            }
            if (!modelItemDTO.isTouched()) {
                modelItemDTO = modelItemDTO.clone(modelItemDTO.getValue());
                modelItemDTO.setTouched();
                HashMap<String, ModelItemDTO> changes = new HashMap<String, ModelItemDTO>();
                changes.put(key, modelItemDTO);
                Map<String, List<PersistenceWriteDTO>> result = this.engine.update(this.nestedMap, changes, true).getPersistenceWriteDTOs();
                this.getChangedMap().putAll(result);
            }
        }

        public ModelItemDTO getTable(String key) {
            Map<String, List<PersistenceWriteDTO>> result;
            HashMap<String, ModelItemDTO> changes;
            ModelItemDTO modelItemDTO = (ModelItemDTO)this.nestedMap.get(key);
            if (modelItemDTO == null) {
                modelItemDTO = new ModelItemDTO(new HashSet(), 1);
                modelItemDTO.setTouched();
                changes = new HashMap();
                changes.put(key, modelItemDTO);
                result = this.engine.update(this.nestedMap, changes, true).getPersistenceWriteDTOs();
                this.getChangedMap().putAll(result);
            }
            if (modelItemDTO.getValue() == null || !modelItemDTO.isTouched()) {
                if (!modelItemDTO.isTouched()) {
                    modelItemDTO = modelItemDTO.clone(modelItemDTO.getValue());
                    modelItemDTO.setTouched();
                }
                changes = new HashMap<String, ModelItemDTO>();
                changes.put(key, modelItemDTO);
                result = this.engine.update(this.nestedMap, changes, true).getPersistenceWriteDTOs();
                this.getChangedMap().putAll(result);
            }
            return modelItemDTO;
        }

        public ModelItemDTO getWithoutTouch(String key) {
            ModelItemDTO modelItemDTO = (ModelItemDTO)this.nestedMap.get(key);
            if (modelItemDTO == null) {
                modelItemDTO = new ModelItemDTO(null, 3);
            }
            return modelItemDTO;
        }
    }
}

