/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay;

import java.io.Serializable;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DisplayItemUniqueID
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -3582471180526322474L;
    public static final String PART_SEPARATOR = "_";
    private final @NonNull String formName;
    private final @NonNull String localId;
    private final @NonNull String id;

    public DisplayItemUniqueID(@NonNull String formName, @NonNull String localId) {
        Validate.notEmpty((CharSequence)formName);
        Validate.notEmpty((CharSequence)localId);
        this.formName = formName;
        this.localId = localId;
        this.id = formName + PART_SEPARATOR + localId;
    }

    public DisplayItemUniqueID(@NonNull String formName, long localId) {
        this(formName, String.valueOf(localId));
    }

    public @NonNull String getFormName() {
        return this.formName;
    }

    public @NonNull String getLocalId() {
        return this.localId;
    }

    public @NonNull String getId() {
        return this.id;
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplayItemUniqueID that = (DisplayItemUniqueID)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected DisplayItemUniqueID clone() throws CloneNotSupportedException {
        return (DisplayItemUniqueID)super.clone();
    }

    public DisplayItemUniqueID appendLocal(@NonNull String additionalLocalId) {
        Validate.notEmpty((CharSequence)additionalLocalId);
        return new DisplayItemUniqueID(this.formName, this.localId + additionalLocalId);
    }
}

