/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class InputSameValidator
implements Validator {
    private final Reference refOtherField;
    private final boolean warning;
    private final String messageKey;

    public InputSameValidator(Reference refOtherField, boolean warning, String messageKey) {
        this.refOtherField = refOtherField;
        this.warning = warning;
        this.messageKey = messageKey;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        this.refOtherField.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        if (modelItemDTO == null || modelItemDTO.getValue() == null) {
            return modelItemDTO;
        }
        ModelItemDTO midOtherField = dataModel.get(EngineUtil.mergeModelKey(this.refOtherField.getName(), dataModelKey));
        if (midOtherField == null || midOtherField.getValue() == null) {
            return modelItemDTO;
        }
        if (modelItemDTO.getValue().equals(midOtherField.getValue())) {
            return modelItemDTO;
        }
        ModelItemDTO result = modelItemDTO;
        result = this.warning ? result.clone(2, this.messageKey, null, 2) : result.clone(4, this.messageKey, null, 4);
        return result;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            Reference refOtherField = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Reference) {
                        refOtherField = (Reference)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            if (refOtherField == null) {
                throw new ElementParserException("InputSameValidator needs Reference to the Object to compare with");
            }
            boolean warning = element.getAttribute("warning") != null && element.getAttributeValue("warning").equalsIgnoreCase("true");
            String messageKey = element.getAttributeValue("message");
            InputSameValidator result = new InputSameValidator(refOtherField, warning, messageKey);
            return new ClassObjectPair(InputSameValidator.class, (Object)result);
        }
    }
}

