/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractXify
implements Validator {
    private final List<CalcItem> calcItems;
    private final boolean booleanExpression;
    private final String messageKey;
    private final Boolean result;
    private LogicModelItem lmi = null;

    protected AbstractXify(@NonNull List<CalcItem> calcItems, boolean booleanExpression, boolean result, @Nullable String messageKey) {
        this.calcItems = Objects.requireNonNull(calcItems);
        this.booleanExpression = booleanExpression;
        this.messageKey = messageKey;
        this.result = result;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        for (CalcItem ci : this.calcItems) {
            if (ci instanceof Reference) {
                ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
                continue;
            }
            if (!(ci instanceof ComplexCalcItem)) continue;
            ((ComplexCalcItem)ci).initializeReferences(logicModel, logicModelItem);
        }
        this.lmi = logicModelItem;
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        if (dataModel.allowActiveValidations()) {
            Object value = null;
            if (this.calcItems != null && !this.calcItems.isEmpty()) {
                FastStack stack = new FastStack();
                for (CalcItem calcItem : this.calcItems) {
                    try {
                        calcItem.evaluate(dataModel, stack, dataModelKey);
                    }
                    catch (RuntimeException rte) {
                        throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
                    }
                }
                value = stack.isEmpty() ? null : stack.pop();
            } else {
                value = modelItemDTO.getValue();
            }
            if (value instanceof Boolean && (Boolean)value == this.booleanExpression && (this.lmi.deleteSubValues(dataModel, dataModelKey, false, null) || modelItemDTO.getValue() != null)) {
                if (this.messageKey != null && !this.messageKey.isEmpty()) {
                    dataModel.addDeleteWarning(new MessageItemDTO(this.messageKey, null, 2));
                }
                modelItemDTO = modelItemDTO.clone(this.result);
            }
        }
        return modelItemDTO;
    }

    protected static abstract class AbstractXMLFactory
    implements ElementParser {
        private final boolean booleanExpression;

        protected AbstractXMLFactory(boolean booleanExpression) {
            this.booleanExpression = booleanExpression;
        }

        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Boolean b;
            ArrayList<CalcItem> calcItems = new ArrayList<CalcItem>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof CalcItem) {
                        calcItems.add((CalcItem)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            if (element.getAttributeValue("ref") != null) {
                throw new ElementParserException("ref attribute is deprecated in delete validators (" + element.getAttributeValue("ref") + ")");
            }
            String message = element.getAttributeValue("message");
            if (message != null && message.isEmpty()) {
                message = null;
            }
            if (message == null && !(b = Boolean.valueOf(element.getAttributeValue("no-message"))).booleanValue()) {
                Element parent = element.getParent();
                assert (parent != null);
                String errMsg = parent.getName() + " (" + parent.getAttribute("name") + ") - Falsify Validator: no-message attribute must be true, if no message is defined";
                throw new ElementParserException(errMsg);
            }
            AbstractXify result = this.createInstance(calcItems, message);
            return new ClassObjectPair(result.getClass(), (Object)result);
        }

        public boolean isBooleanExpression() {
            return this.booleanExpression;
        }

        protected abstract @NonNull AbstractXify createInstance(@NonNull List<CalcItem> var1, @Nullable String var2);
    }
}

