/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ResourceLineIterator
implements Iterator<String> {
    private static final Pattern COMMENT_PTN = Pattern.compile("#.*");
    private static final String DEFAULT_DELIMITER = "\t";
    private int lineNumber = 0;
    private String nextLine;
    private BufferedReader bufferedReader;

    public ResourceLineIterator(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException("Reader cannot be null.");
        }
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.bufferedReader = (BufferedReader)reader;
        this.loadNext();
    }

    @Override
    public boolean hasNext() {
        return this.nextLine != null;
    }

    @Override
    public @NonNull String next() {
        if (this.nextLine == null) {
            throw new NoSuchElementException("No more line to read.");
        }
        String tmp = this.nextLine;
        try {
            this.loadNext();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot process resource.", e);
        }
        return tmp;
    }

    public String[] splitNext(int expectedTokenCount) {
        return this.splitNext(DEFAULT_DELIMITER, expectedTokenCount);
    }

    public String[] splitNext(String delimiter, int expectedTokenCount) {
        Object[] tokens = this.next().split(delimiter);
        if (tokens.length != expectedTokenCount) {
            throw new IllegalArgumentException(String.format("Wrong token count (expected %d, got %d): %s", expectedTokenCount, tokens.length, Arrays.toString(tokens)));
        }
        return tokens;
    }

    private void loadNext() throws IOException {
        String line;
        while ((line = this.bufferedReader.readLine()) != null) {
            ++this.lineNumber;
            if ((line = this.trimComments(line)).isEmpty()) continue;
        }
        this.nextLine = line;
    }

    private String trimComments(String line) {
        assert (line != null);
        line = COMMENT_PTN.matcher(line).replaceFirst("");
        return line.trim();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator is read-only.");
    }
}

