/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.util;

import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DebugUtil {
    private DebugUtil() {
    }

    public static LinkedHashMap<String, String> filterModel(@NonNull Map<String, ModelItemDTO> dataModel, @Nullable Predicate<@NonNull String> dmkPredicate, @Nullable Predicate<@Nullable ModelItemDTO> miDTOPredicate) {
        Objects.requireNonNull(dataModel);
        Predicate<String> keyPredicate = dmkPredicate != null ? dmkPredicate : x -> true;
        Predicate<ModelItemDTO> valuePredicate = miDTOPredicate != null ? miDTOPredicate : x -> true;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        dataModel.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).filter(e -> keyPredicate.test((String)e.getKey())).filter(e -> valuePredicate.test((ModelItemDTO)e.getValue())).forEach(e -> result.put((String)e.getKey(), e.getValue() != null ? ((ModelItemDTO)e.getValue()).toDebugString() : null));
        return result;
    }

    private static <T> T throwingMergeFunction(T u, T v) {
        throw new IllegalStateException(String.format("Something went wrong, merge not allowed, key: %s", u));
    }

    public static Predicate<@NonNull String> dmkStartsWith(@NonNull String dmkStart) {
        return dmk -> dmk.startsWith(dmkStart);
    }

    public static Predicate<@NonNull String> dmkMatches(@NonNull String dmkPattern) {
        return DebugUtil.dmkMatches(dmkPattern, 0);
    }

    public static Predicate<@NonNull String> dmkMatches(@NonNull String dmkPattern, int patternFlags) {
        Objects.requireNonNull(dmkPattern);
        Pattern pattern = Pattern.compile(dmkPattern, patternFlags);
        return dmk -> pattern.matcher((CharSequence)dmk).matches();
    }

    public static Predicate<@Nullable ModelItemDTO> withoutEntry() {
        return Objects::isNull;
    }

    public static Predicate<@Nullable ModelItemDTO> withState(int state) {
        return miDTO -> miDTO != null && miDTO.getState() == state;
    }

    public static Predicate<@Nullable ModelItemDTO> withValue(@Nullable Object value) {
        return miDTO -> miDTO != null && Objects.equals(miDTO.getValue(), value);
    }
}

