/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Text
extends LogicModelItem {
    private final String defaultValue;
    private final boolean hasInitialGreenState;

    public Text(String name, String persistenceKeyTemplate, String defaultValue, boolean readonly, String importPrevious, boolean hasInitialGreenState, boolean readonlyIfTransparent, boolean barcode) {
        super(name, null, persistenceKeyTemplate, readonly, importPrevious, readonlyIfTransparent, barcode, new SimpleValuePersistenceHint());
        this.defaultValue = defaultValue;
        this.hasInitialGreenState = hasInitialGreenState;
    }

    @Override
    protected ModelItemDTO getDefaultValue(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        return this.defaultValue != null ? new ModelItemDTO(this.defaultValue) : null;
    }

    @Override
    protected boolean hasAnInitialGreenState() {
        if (this.hasInitialGreenState) {
            return true;
        }
        return super.hasAnInitialGreenState();
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<Validator> validators = new ArrayList<Validator>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String string = subElement.getName();
                    ElementParser parser = factory.getParser(string);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Validator) {
                        validators.add((Validator)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException parserNotRegisteredException) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)parserNotRegisteredException);
                }
            }
            Engine.setMandatory(element, validators);
            Text result = new Text(element.getAttributeValue("name"), element.getAttributeValue("pKey"), element.getAttributeValue("default"), (boolean)Boolean.valueOf(element.getAttributeValue("readonly")), element.getAttributeValue("import"), (boolean)Boolean.valueOf(element.getAttributeValue("has-initial-green-state")), (boolean)Boolean.valueOf(element.getAttributeValue("readonly-if-transparent")), Boolean.valueOf(element.getAttributeValue("barcode")));
            for (Object e : validators) {
                result.addValidator((Validator)e);
            }
            return new ClassObjectPair(Text.class, (Object)result);
        }
    }
}

