/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.SimpleFormElement;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ImageXMLFactory
implements ElementParser {
    public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
        String fileName = element.getAttributeValue("fileName");
        Set<String> languages = ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang"));
        int printMode = ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printItem"));
        boolean inputItem = ExpertDisplayUtil.getBoolean(element.getAttributeValue("inputItem"), true);
        ExpertDisplayInfoDTO.ImageDTO item = new ExpertDisplayInfoDTO.ImageDTO(ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), fileName, ExpertDisplayUtil.getInt(element.getAttributeValue("page"), 1), printMode, ExpertDisplayUtil.generateUniqueItemIdentifier(ImageXMLFactory.class.getName()));
        return new ClassObjectPair(ExpertFormDisplayModelItem.class, (Object)new SimpleFormElement(item, languages, printMode, inputItem));
    }
}

