/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExtraPagesSumItem
extends ExpertDisplayModelItem {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int alignment;
    private final FontDTO font;
    private final ColorDTO bgColor;

    public ExtraPagesSumItem(int x, int y, int width, int height, FontDTO font, ColorDTO bgColor, int alignment, int printMode, boolean inputItem, Set<String> languages) {
        super(languages, printMode, false);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.alignment = alignment;
        this.font = font;
        this.bgColor = bgColor;
    }

    public List<ExpertDisplayModelItem> getChildren() {
        return Collections.emptyList();
    }

    public ExpertDisplayInfoDTO.TableDTO.ExtraPagesSumDTO getDTO(FontDTO colFont, int colAlign) {
        return new ExpertDisplayInfoDTO.TableDTO.ExtraPagesSumDTO(this.x, this.y, this.width, this.height, this.font == null ? colFont : this.font, this.bgColor, this.alignment < 0 ? colAlign : this.alignment, this.getPrintMode(), this.getUniqueItemIdentifier());
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            FontDTO font = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof FontDTO) {
                        font = (FontDTO)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            int halign = -1;
            String align = element.getAttributeValue("halign");
            if (align != null && !align.isEmpty()) {
                halign = ExpertDisplayUtil.parseHAlignment(align);
            }
            return new ClassObjectPair(ExtraPagesSumItem.class, (Object)new ExtraPagesSumItem(ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), font, ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), halign, ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printItem"), 8), ExpertDisplayUtil.getBoolean(element.getAttributeValue("inputItem"), true), ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang"))));
        }
    }
}

