/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLabelAddOn;
import ch.dvbern.tax.common.engine.modelitems.Table;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExpertNavigationItem
extends ExpertDisplayModelItem {
    public static final String FORM_NAME_NAV_PREFIX = "nav.expert.";
    private ExpertNavigationItem parent;
    private final String name;
    private final String descKey;
    private final String iconName;
    private final List<ExpertNavigationItem> subItems;
    private final String stateItemNames;
    private final String printStateItemNames;
    private final String tableItemName;
    private int superTablestructs;
    private List<LogicModelItem> stateItems;
    private List<LogicModelItem> printStateItems;
    private LogicModelItem tableItem;
    private final boolean extraForm;
    private final boolean printGesamtausdruck;
    private final boolean printEinzeldruck;
    private final String entryDescKey;
    private final String newEntryDescKey;
    private final String entryKey;
    private final String newEntryKey;
    private final List<ExpertLabelAddOn> entryDescAddOns;
    private boolean showNewEntry = true;
    private boolean deletableEntry = true;
    private final List<ExpertDisplayModelItem> children;
    private final String deleteItemName;
    private LogicModelItem deleteItem;
    private static Comparator<Object> tableRowSorter = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return Integer.valueOf((String)o1).compareTo(Integer.valueOf((String)o2));
            }
            return 0;
        }
    };

    public ExpertNavigationItem(String name, String iconName, List<ExpertNavigationItem> subItems, String stateItemNames, String tableItemName, boolean extraForm, String printStateItemNames, String entryDescKey, List<ExpertLabelAddOn> entryDescAddOns, String newEntryDescKey, String newEntryKey, String entryKey, boolean showNewEntry, boolean deletableEntry, String descKey, String deleteItem, boolean printGesamtausdruck, boolean printEinzeldruck) {
        super(null, 0, true);
        this.name = name;
        this.iconName = iconName;
        this.subItems = subItems;
        this.stateItemNames = stateItemNames;
        this.tableItemName = tableItemName;
        this.extraForm = extraForm;
        this.printStateItemNames = printStateItemNames;
        this.entryDescKey = entryDescKey;
        this.newEntryDescKey = newEntryDescKey;
        this.entryDescAddOns = entryDescAddOns;
        this.entryKey = entryKey;
        this.showNewEntry = showNewEntry;
        this.deletableEntry = deletableEntry;
        this.newEntryKey = newEntryKey;
        this.descKey = descKey;
        this.deleteItemName = deleteItem;
        this.printGesamtausdruck = printGesamtausdruck;
        this.printEinzeldruck = printEinzeldruck;
        this.children = new ArrayList<ExpertDisplayModelItem>();
        if (subItems != null) {
            this.children.addAll(subItems);
        }
        if (entryDescAddOns != null) {
            this.children.addAll(entryDescAddOns);
        }
    }

    public String getAccessKey() {
        return this.name + "#";
    }

    public String getName() {
        return this.name;
    }

    public List<LogicModelItem> getStateItems() {
        return this.stateItems;
    }

    public List<ExpertDisplayModelItem> getChildren() {
        return this.children;
    }

    public int getSuperTablestructs() {
        return this.superTablestructs;
    }

    public List<ExpertNavigationItem> getSubItems() {
        return this.subItems;
    }

    protected boolean isTableNavigation() {
        return this.tableItemName != null;
    }

    private void setParent(ExpertNavigationItem parent) {
        this.parent = parent;
    }

    @Override
    public ExpertNavigationItem getParent() {
        return this.parent;
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModel, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModel, navigationItems);
        if (this.parent == null) {
            this.superTablestructs = 0;
        } else {
            this.superTablestructs = this.parent.getSuperTablestructs();
            if (this.parent.isTableNavigation()) {
                ++this.superTablestructs;
            }
        }
        if (this.tableItemName != null) {
            this.tableItem = logicModel.get(this.tableItemName);
            if (!(this.tableItem instanceof Table)) {
                throw new InvalidModelException("invalid reference to table item (" + this.tableItemName + ") in " + this.getClass().getName() + " (" + this.name + ")");
            }
            String nwtis = this.tableItem.getNameWithTableIndexShapes();
            if (ExpertDisplayUtil.getShapeCount(nwtis) > this.superTablestructs) {
                throw new InvalidModelException("invalid reference to table item (" + this.tableItemName + ") in " + this.getClass().getName() + " (" + this.name + ")");
            }
        }
        this.stateItems = this.resolveStateItems(this.stateItemNames, logicModel);
        if (this.stateItems.isEmpty()) {
            throw new InvalidModelException("missing stateItems in " + this.getClass().getName() + " (" + this.name + ")");
        }
        this.printStateItems = this.resolveStateItems(this.printStateItemNames, logicModel);
        if (this.deleteItemName != null) {
            this.deleteItem = logicModel.get(this.deleteItemName);
            if (this.deleteItem == null) {
                throw new InvalidModelException("invalid reference to delete item (" + this.deleteItemName + ") in " + this.getClass().getName() + " (" + this.name + ")");
            }
        }
    }

    private List<LogicModelItem> resolveStateItems(String names, Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        if (names == null || names.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LogicModelItem> items = new ArrayList<LogicModelItem>();
        StringTokenizer st = new StringTokenizer(names, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            LogicModelItem lmi = logicModel.get(s);
            if (lmi == null) {
                throw new InvalidModelException("invalid state reference into logic Model (" + s + ") in " + this.getClass().getName() + " (" + this.name + ")");
            }
            String nwtis = lmi.getNameWithTableIndexShapes();
            if (ExpertDisplayUtil.getShapeCount(nwtis) > this.superTablestructs) {
                throw new InvalidModelException("invalid state reference into logic Model (" + s + ") in " + this.getClass().getName() + " (" + this.name + ")");
            }
            items.add(lmi);
        }
        return items;
    }

    public ExpertDisplayInfoDTO.NavigationDTO getDTO(@NonNull ExpertDisplayModel.ProtectedMap dataModel, @Nullable String formKey, @NonNull FastStack tableIndizes, @Nullable FastStack navigationPath, boolean readonly) {
        StringBuilder tableKey = new StringBuilder("X#");
        Iterator<Object> i = tableIndizes.iterator();
        while (i.hasNext()) {
            tableKey.append(i.next());
        }
        int state = this.calcState(this.stateItems, dataModel, tableKey.toString());
        if (state == 12) {
            return null;
        }
        if (state == 11 && readonly) {
            return null;
        }
        int printState = this.calcState(this.printStateItems, dataModel, tableKey.toString());
        ArrayList<ExpertDisplayInfoDTO.NavigationDTO> subItemDTOs = null;
        ExpertDisplayInfoDTO.NavigationDTO newEntryItem = null;
        if (navigationPath == null || !navigationPath.isEmpty() && navigationPath.peek() == this) {
            if (navigationPath != null) {
                navigationPath.pop();
            }
            subItemDTOs = new ArrayList();
            if (this.tableItem != null) {
                int newIndex = 90000;
                String tableDMK = ExpertDisplayUtil.getModelItemKey(this.tableItem, tableKey.toString());
                ModelItemDTO miDTO = dataModel.getWithoutTouch(tableDMK);
                if (miDTO != null && miDTO.getValue() != null) {
                    ArrayList sortedRows = new ArrayList((Set)miDTO.getValue());
                    Collections.sort(sortedRows, tableRowSorter);
                    for (Object currentTableEntryIndex : sortedRows) {
                        int ctei = Integer.valueOf(currentTableEntryIndex.toString());
                        if (ctei >= newIndex) {
                            newIndex = ctei + 1;
                        }
                        tableIndizes.push(currentTableEntryIndex);
                        boolean tableEntryIsSelected = formKey == null || ExpertDisplayUtil.isTableEntrySelected(this.superTablestructs, currentTableEntryIndex, formKey);
                        String fak = this.getAccessKey(tableIndizes);
                        String rowDMK = tableDMK + "." + String.valueOf(currentTableEntryIndex);
                        ModelItemDTO rowDTO = dataModel.getWithoutTouch(rowDMK);
                        List<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO> descAddOns = this.getDescAddOns(dataModel, fak);
                        List<ExpertDisplayInfoDTO.NavigationDTO> tableEntrySubItemDTOs = this.getSubItemDTOs(dataModel, formKey, tableIndizes, navigationPath, readonly);
                        if (tableEntrySubItemDTOs != null && !tableEntrySubItemDTOs.isEmpty()) {
                            ExpertDisplayInfoDTO.NavigationDTO entry = tableEntrySubItemDTOs.get(0);
                            fak = entry.getAccessKey();
                        }
                        subItemDTOs.add(new ExpertDisplayInfoDTO.NavigationDTO(rowDTO.getState(), this.entryKey, fak, null, tableEntrySubItemDTOs, tableEntryIsSelected, rowDMK, false, printState, this.entryDescKey, descAddOns, this.deletableEntry, true, null, this.getUniqueItemIdentifier().appendLocal("." + formKey + "." + String.valueOf(currentTableEntryIndex)), this.printGesamtausdruck, this.printEinzeldruck));
                        tableIndizes.pop();
                    }
                }
                if (!readonly) {
                    tableIndizes.push(Integer.valueOf(newIndex).toString());
                    List<ExpertDisplayInfoDTO.NavigationDTO> tableEntrySubItemDTOs = this.getSubItemDTOs(dataModel, formKey, tableIndizes, navigationPath, readonly);
                    String fak = this.getAccessKey(tableIndizes);
                    if (tableEntrySubItemDTOs != null && !tableEntrySubItemDTOs.isEmpty()) {
                        ExpertDisplayInfoDTO.NavigationDTO entry = tableEntrySubItemDTOs.get(0);
                        fak = entry.getAccessKey();
                    }
                    if (ExpertDisplayUtil.isTableEntrySelected(this.superTablestructs, newIndex, formKey)) {
                        subItemDTOs.add(new ExpertDisplayInfoDTO.NavigationDTO(3, this.entryKey, fak, null, tableEntrySubItemDTOs, true, null, false, printState, this.entryDescKey, this.getDescAddOns(dataModel, fak), true, true, null, this.getUniqueItemIdentifier().appendLocal("." + formKey + "." + newIndex), this.printGesamtausdruck, this.printEinzeldruck));
                    }
                    if (this.showNewEntry) {
                        newEntryItem = new ExpertDisplayInfoDTO.NavigationDTO(3, this.newEntryKey, fak, null, null, false, null, false, printState, this.newEntryDescKey, null, false, false, null, this.getUniqueItemIdentifier().appendLocal("." + formKey + ".NEW"), this.printGesamtausdruck, this.printEinzeldruck);
                        subItemDTOs.add(newEntryItem);
                    }
                    tableIndizes.pop();
                }
            } else {
                subItemDTOs = this.getSubItemDTOs(dataModel, formKey, tableIndizes, navigationPath, readonly);
            }
        }
        String fak = this.getAccessKey(tableIndizes);
        boolean selected = fak.equals(formKey);
        String dmkDelete = null;
        if (this.deleteItem != null) {
            dmkDelete = ExpertDisplayUtil.getModelItemKey(this.deleteItem, fak);
        }
        return new ExpertDisplayInfoDTO.NavigationDTO(state, this.name, fak, this.iconName, subItemDTOs, selected, dmkDelete, this.extraForm, printState, this.descKey, null, dmkDelete != null, true, newEntryItem, this.getUniqueItemIdentifier().appendLocal("." + formKey), this.printGesamtausdruck, this.printEinzeldruck);
    }

    private int calcState(List<LogicModelItem> items, ExpertDisplayModel.ProtectedMap dataModel, String tableKey) {
        int state = 1;
        if (!items.isEmpty()) {
            int maxPropagateableState = 1;
            int minState = 12;
            for (LogicModelItem lmi : items) {
                ModelItemDTO miDTO = dataModel.getWithoutTouch(ExpertDisplayUtil.getModelItemKey(lmi, tableKey));
                int newState = miDTO.getState();
                if (ModelItemDTO.isPropagatableState(newState) && ModelItemDTO.isMoreImportantState(newState, maxPropagateableState)) {
                    maxPropagateableState = newState;
                }
                if (ModelItemDTO.isMoreImportantState(newState, minState)) continue;
                minState = newState;
            }
            state = !ModelItemDTO.isPropagatableState(minState) ? minState : maxPropagateableState;
        }
        return state;
    }

    private String getAccessKey(FastStack tableIndizes) {
        StringBuilder result = new StringBuilder(this.name);
        result.append('#');
        Iterator<Object> j = tableIndizes.iterator();
        while (j.hasNext()) {
            result.append(j.next().toString());
            if (!j.hasNext()) continue;
            result.append('.');
        }
        return result.toString();
    }

    private List<ExpertDisplayInfoDTO.NavigationDTO> getSubItemDTOs(ExpertDisplayModel.ProtectedMap dataModel, String formKey, FastStack tableIndizes, FastStack navigationPath, boolean readonly) {
        ArrayList<ExpertDisplayInfoDTO.NavigationDTO> result = null;
        if (this.subItems != null) {
            for (ExpertNavigationItem element : this.subItems) {
                ExpertNavigationItem subItem = element;
                ExpertDisplayInfoDTO.NavigationDTO subItemDTO = subItem.getDTO(dataModel, formKey, tableIndizes, navigationPath, readonly);
                if (subItemDTO == null) continue;
                if (result == null) {
                    result = new ArrayList<ExpertDisplayInfoDTO.NavigationDTO>();
                }
                result.add(subItemDTO);
            }
        }
        return result;
    }

    private List<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO> getDescAddOns(ExpertDisplayModel.ProtectedMap dataModel, String fak) {
        ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO> labelAddOnDTOs = null;
        if (this.entryDescAddOns != null && !this.entryDescAddOns.isEmpty()) {
            ExpertDisplayModel.RequestContext requestContext = new ExpertDisplayModel.RequestContext(dataModel, fak, null, null, null, null, null, null);
            labelAddOnDTOs = new ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO>();
            for (ExpertLabelAddOn labelAddOn : this.entryDescAddOns) {
                ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO labelAddOnDTO = labelAddOn.getLabelAddOnDTO(requestContext);
                labelAddOnDTOs.add(labelAddOnDTO);
            }
        }
        return labelAddOnDTOs;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<ExpertNavigationItem> subItems = null;
            ArrayList<ExpertLabelAddOn> descAddOns = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertNavigationItem) {
                        if (subItems == null) {
                            subItems = new ArrayList<ExpertNavigationItem>();
                        }
                        subItems.add((ExpertNavigationItem)ref);
                        continue;
                    }
                    if (ref instanceof ExpertLabelAddOn) {
                        if (descAddOns == null) {
                            descAddOns = new ArrayList<ExpertLabelAddOn>();
                        }
                        descAddOns.add((ExpertLabelAddOn)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            String name = element.getAttributeValue("name");
            Object descKey = element.getAttributeValue("descKey");
            if (descKey == null) {
                descKey = ExpertNavigationItem.FORM_NAME_NAV_PREFIX + name;
            }
            ExpertNavigationItem eni = new ExpertNavigationItem(name, element.getAttributeValue("icon"), subItems, element.getAttributeValue("stateItems"), element.getAttributeValue("table"), ExpertDisplayUtil.getBoolean(element.getAttributeValue("extraForm"), false), element.getAttributeValue("printStateItems"), element.getAttributeValue("entryDescKey"), descAddOns, element.getAttributeValue("newEntryDescKey"), element.getAttributeValue("newEntryKey"), element.getAttributeValue("entryKey"), ExpertDisplayUtil.getBoolean(element.getAttributeValue("showNewEntry"), true), ExpertDisplayUtil.getBoolean(element.getAttributeValue("deletableEntry"), true), (String)descKey, element.getAttributeValue("deleteItem"), ExpertDisplayUtil.getBoolean(element.getAttributeValue("printGesamtausdruck"), true), ExpertDisplayUtil.getBoolean(element.getAttributeValue("printEinzeldruck"), true));
            if (subItems != null) {
                for (ExpertNavigationItem subItem : subItems) {
                    subItem.setParent(eni);
                }
            }
            return new ClassObjectPair(ExpertNavigationItem.class, (Object)eni);
        }
    }
}

