/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLabelAddOn;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListRowContent;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpertListLabelRowItem
extends ExpertListRowContent {
    private final String labelKey;
    private final String stateKey;
    private final List<ExpertLabelAddOn> labelAddOns;
    private LogicModelItem stateItem;
    private final String listItemChar;
    private final FontDTO font;

    public ExpertListLabelRowItem(String labelKey, String stateKey, List<ExpertLabelAddOn> labelAddOns, String listItemChar, FontDTO font) {
        super(null, 8, true);
        this.labelKey = labelKey;
        this.stateKey = stateKey;
        this.labelAddOns = labelAddOns;
        this.listItemChar = listItemChar;
        this.font = font;
    }

    public List<ExpertLabelAddOn> getChildren() {
        return this.labelAddOns;
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        if (this.stateKey != null) {
            this.stateItem = logicModelItems.get(this.stateKey);
            if (this.stateItem == null) {
                throw new InvalidModelException("invalid state-reference in Row (key=" + this.stateKey + ")");
            }
        }
    }

    public List<ExpertDisplayInfoDTO.ListDTO.LabelRowDTO> getRowDTOs(ExpertDisplayModel.RequestContext requestContext) {
        if (this.stateItem != null) {
            String dmk = ExpertDisplayUtil.getModelItemKey(this.stateItem, requestContext.getFormAccessKey());
            ModelItemDTO miDTO = requestContext.getDataModel().get(dmk);
            if (miDTO == null) {
                return null;
            }
            if (miDTO.getState() == 12) {
                return null;
            }
        }
        ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO> labelAddOnDTOs = null;
        if (this.labelAddOns != null && !this.labelAddOns.isEmpty()) {
            labelAddOnDTOs = new ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO>();
            Iterator<ExpertLabelAddOn> iterator = this.labelAddOns.iterator();
            while (iterator.hasNext()) {
                ExpertLabelAddOn object;
                ExpertLabelAddOn labelAddOn = object = iterator.next();
                labelAddOnDTOs.add(labelAddOn.getLabelAddOnDTO(requestContext));
            }
        }
        return Collections.singletonList(new ExpertDisplayInfoDTO.ListDTO.LabelRowDTO(this.labelKey, labelAddOnDTOs, this.listItemChar, this.font));
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<ExpertLabelAddOn> labelAddOns = null;
            FontDTO font = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertLabelAddOn) {
                        if (labelAddOns == null) {
                            labelAddOns = new ArrayList<ExpertLabelAddOn>();
                        }
                        labelAddOns.add((ExpertLabelAddOn)ref);
                        continue;
                    }
                    if (ref instanceof FontDTO) {
                        font = (FontDTO)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            String key = element.getAttributeValue("key");
            if (key == null) {
                key = element.getAttributeValue("name");
            }
            if (key == null) {
                key = element.getAttributeValue("i18nKey");
            }
            String listItemChar = "\u2022";
            if (element.getAttribute("list-item-char") != null) {
                listItemChar = element.getAttributeValue("list-item-char");
            }
            ExpertListLabelRowItem eli = new ExpertListLabelRowItem(key, element.getAttributeValue("state"), labelAddOns, listItemChar, font);
            return new ClassObjectPair(ExpertListLabelRowItem.class, (Object)eli);
        }
    }
}

