/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DDataDTO;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormDisplayModelItem;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Barcode2DContainerItem
extends ExpertFormDisplayModelItem {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int length;
    private final int errorCorrection;
    private final int rowHeight;
    private final int type;
    private final int rows;
    private final int columns;
    private final String key;
    private final float aspectRatio;
    private final ColorDTO bgColor;
    private final List<ExpertDisplayInfoDTO.Barcode2DDTO> barcodes;
    private final Barcode2DGenerator generator;

    public Barcode2DContainerItem(int x, int y, int width, int height, ColorDTO bgColor, String key, List<ExpertDisplayInfoDTO.Barcode2DDTO> barcodes, int length, int errorCorrection, float aspectRatio, int rowHeight, int type, int columns, int rows, Barcode2DGenerator generator, Set<String> languages) {
        super(languages, 1, false);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.bgColor = bgColor;
        this.key = key;
        this.barcodes = barcodes;
        this.length = length;
        this.errorCorrection = errorCorrection;
        this.aspectRatio = aspectRatio;
        this.rowHeight = rowHeight;
        this.generator = generator;
        this.type = type;
        this.rows = rows;
        this.columns = columns;
    }

    public List<ExpertDisplayModelItem> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) {
        Barcode2DDataDTO data = this.generator != null ? new Barcode2DDataDTO(this.generator.generateData(requestContext), this.generator.generateId(requestContext), this.generator.getContentType()) : null;
        return new ExpertDisplayInfoDTO.Barcode2DContainerDTO(this.x, this.y, this.width, this.height, this.bgColor, data, this.key, this.barcodes, this.length, this.errorCorrection, this.aspectRatio, this.rowHeight, this.type, this.columns, this.rows, this.getUniqueItemIdentifier());
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            String key;
            ArrayList<ExpertDisplayInfoDTO.Barcode2DDTO> barcodes = new ArrayList<ExpertDisplayInfoDTO.Barcode2DDTO>();
            Barcode2DGenerator generator = null;
            List children = element.getChildren();
            for (Element subElement : children) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertDisplayInfoDTO.Barcode2DDTO) {
                        barcodes.add((ExpertDisplayInfoDTO.Barcode2DDTO)ref);
                        continue;
                    }
                    if (ref instanceof Barcode2DGenerator) {
                        generator = (Barcode2DGenerator)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            int type = 2;
            String typeStr = element.getAttributeValue("type").toLowerCase();
            if ("macropdf417".equals(typeStr)) {
                type = 1;
            }
            if (!(generator != null ^ (key = element.getAttribute("key")) != null)) {
                throw new ElementParserException("Exactly one of barcode generator or barcode key must be specified");
            }
            return new ClassObjectPair(Barcode2DContainerItem.class, (Object)new Barcode2DContainerItem(ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), key, barcodes, ExpertDisplayUtil.getInt(element.getAttributeValue("length"), 800), ExpertDisplayUtil.getInt(element.getAttributeValue("errorCorrection"), 5), ExpertDisplayUtil.getFloat(element.getAttributeValue("aspectRatio"), 1.2f), ExpertDisplayUtil.getInt(element.getAttributeValue("rowHeight"), 3), type, ExpertDisplayUtil.getInt(element.getAttributeValue("columns"), 0), ExpertDisplayUtil.getInt(element.getAttributeValue("rows"), 0), generator, ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang"))));
        }
    }
}

