/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SystemPropertyGetter
extends LogicModelItem {
    private final String systemProperty;

    public SystemPropertyGetter(@NonNull String name, String systemProperty) {
        super(name, null, null, true, null, true, false, new SimpleValuePersistenceHint());
        this.systemProperty = Objects.requireNonNull(systemProperty);
    }

    @Override
    protected @Nullable ModelItemDTO getDefaultValue(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        if (this.systemProperty == null) {
            return null;
        }
        String property = this.systemProperty;
        String result = System.getProperties().getProperty(property);
        return new ModelItemDTO(result, 1);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            SystemPropertyGetter result = new SystemPropertyGetter(element.getAttributeValue("name"), element.getAttributeValue("property"));
            return new ClassObjectPair(SystemPropertyGetter.class, (Object)result);
        }
    }
}

