/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.modelitems.Select;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import java.util.Locale;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SelectRef
extends Reference
implements CalcItem {
    private final Reference localeRef;

    public SelectRef(String name, Reference localeRef) {
        super(name, false);
        this.localeRef = localeRef;
    }

    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap dataModel, @NonNull FastStack stack, @NonNull String dataModelKey) {
        ModelItemDTO localeDTO;
        if (!(this.getReference() instanceof Select)) {
            throw new IllegalArgumentException("Reference has to be pointing to a Select");
        }
        Select select = (Select)this.getReference();
        ModelItemDTO itemDTO = dataModel.get(EngineUtil.mergeModelKey(this.getName(), dataModelKey));
        if (itemDTO == null || itemDTO.getValue() == null) {
            stack.push(null);
            return;
        }
        Object value = itemDTO.getValue();
        String locale = null;
        if (this.localeRef != null && (localeDTO = dataModel.get(EngineUtil.mergeModelKey(this.localeRef.getName(), dataModelKey))) != null) {
            locale = Objects.toString(localeDTO.getValue());
        }
        OptionItemDTO optionDTO = locale != null ? select.getOptionItems(dataModel, dataModelKey).get(value.toString(), new Locale(locale, "CH")) : select.getOptionItems(dataModel, dataModelKey).get(value.toString());
        stack.push(optionDTO == null ? null : optionDTO.getText());
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            String name = element.getAttributeValue("name");
            if (name == null) {
                throw new ElementParserException("Attribute 'name' is mandatory for select-ref item.");
            }
            Reference localeRef = null;
            if (element.getAttributeValue("localeRef") != null) {
                localeRef = new Reference(element.getAttributeValue("localeRef"), false);
            }
            return new ClassObjectPair(Reference.class, (Object)new SelectRef(name, localeRef));
        }
    }
}

