/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class IsNull
implements CalcItem {
    private final boolean booleanExpression;

    public IsNull(boolean booleanExpression) {
        this.booleanExpression = booleanExpression;
    }

    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("IsNull needs 1 element on stack");
        }
        Object value = stack.pop();
        if (this.booleanExpression == (value == null || value instanceof String && ((String)value).length() <= 0)) {
            stack.push(Boolean.TRUE);
        } else {
            stack.push(Boolean.FALSE);
        }
    }

    public static class XMLFactory
    implements ElementParser {
        private final boolean booleanExpression;

        public XMLFactory(boolean booleanExpression) {
            this.booleanExpression = booleanExpression;
        }

        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            IsNull result = new IsNull(this.booleanExpression);
            return new ClassObjectPair(IsNull.class, (Object)result);
        }
    }
}

