/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FormatDate
implements CalcItem {
    private static final Locale DEFAULT_LOCALE = new Locale("de", "CH");
    private final @NonNull String formatString;

    public FormatDate(@NonNull String formatString) {
        this.formatString = formatString;
    }

    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap dataModel, @NonNull FastStack stack, @NonNull String dataModelKey) {
        Objects.requireNonNull(dataModel);
        Objects.requireNonNull(stack);
        Objects.requireNonNull(dataModelKey);
        Date value = this.popOneValidParam(stack);
        if (value == null) {
            stack.push(null);
            return;
        }
        String formatted = new SimpleDateFormat(this.formatString, DEFAULT_LOCALE).format(value);
        stack.push(formatted);
    }

    private @Nullable Date popOneValidParam(@NonNull FastStack stack) {
        if (stack.size() < 1) {
            throw new IllegalArgumentException("DateFormat needs >= 1 element on stack");
        }
        Object value = stack.pop();
        if (value == null) {
            return null;
        }
        if (!(value instanceof Date)) {
            throw new IllegalArgumentException("argument of DateFormat need to be of type Date but was: " + value.getClass().getName() + ", value: " + String.valueOf(value));
        }
        return (Date)value;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            String pattern = StringUtils.trimToNull((String)element.getAttributeValue("pattern"));
            if (pattern == null) {
                pattern = "dd.MM.yyyy";
            }
            FormatDate result = new FormatDate(pattern);
            return new ClassObjectPair(FormatDate.class, (Object)result);
        }
    }
}

