/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import java.util.Calendar;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CFStartOrEndOfYear
implements CalcItem {
    private final Mode mode;

    private CFStartOrEndOfYear(Mode mode) {
        assert (mode != null);
        this.mode = mode;
    }

    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap dataModel, @NonNull FastStack stack, @NonNull String dataModelKey) {
        Long year = StackUtil.getLong(stack);
        Date outcome = null;
        if (year != null) {
            Calendar cal = Calendar.getInstance(ApplicationConfig.TIMEZONE);
            cal.set(1, year.intValue());
            for (int field : new int[]{2, 5, 11, 12, 13, 14}) {
                assert (this.mode == Mode.START || this.mode == Mode.END);
                cal.set(field, this.mode == Mode.START ? cal.getActualMinimum(field) : cal.getActualMaximum(field));
            }
            outcome = cal.getTime();
        }
        stack.push(outcome);
    }

    public static class XMLFactory
    implements ElementParser {
        private final Mode mode;

        public XMLFactory(@NonNull Mode mode) {
            if (mode == null) {
                throw new NullPointerException("Resolution mode cannot be null.");
            }
            this.mode = mode;
        }

        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            return new ClassObjectPair(CFStartOrEndOfYear.class, (Object)new CFStartOrEndOfYear(this.mode));
        }
    }

    public static enum Mode {
        START,
        END;

    }
}

