/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.ModelChangeListener;
import ch.dvbern.tax.common.engine.modelitems.Module;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Reference {
    protected String name;
    private final boolean relativeReference;
    private LogicModelItem reference;

    public Reference(String name, boolean relativeReference) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name;
        this.relativeReference = relativeReference;
    }

    public String getName() {
        return this.name;
    }

    public String initializeReference(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem, boolean referenceIntoTables) throws InvalidModelException {
        String rToken;
        if (this.relativeReference) {
            LogicModelItem lmi;
            LogicModelItem logicModelItem2 = lmi = logicModelItem instanceof Module ? logicModelItem : logicModelItem.getParent();
            while (this.name.startsWith(".") && lmi != null) {
                lmi = lmi.getParent();
                this.name = this.name.substring(1);
            }
            StringBuilder absName = new StringBuilder(lmi != null ? lmi.getName() : "");
            if (absName.length() > 0) {
                absName.append('.');
            }
            absName.append(this.name);
            this.name = absName.toString();
        }
        StringBuilder listenerName = new StringBuilder();
        StringBuilder referenceName = new StringBuilder();
        StringTokenizer stListener = new StringTokenizer(logicModelItem.getName(), ".");
        StringTokenizer stReference = new StringTokenizer(this.name, ".");
        String lToken = stListener.hasMoreTokens() ? stListener.nextToken() : null;
        String string = rToken = stReference.hasMoreTokens() ? stReference.nextToken() : null;
        while (lToken != null && rToken != null && lToken.equals(rToken)) {
            if (listenerName.length() > 0) {
                listenerName.append('.');
            }
            listenerName.append(lToken);
            if (referenceName.length() > 0) {
                referenceName.append('.');
            }
            referenceName.append(rToken);
            lToken = stListener.hasMoreTokens() ? stListener.nextToken() : null;
            rToken = stReference.hasMoreTokens() ? stReference.nextToken() : null;
        }
        if (lToken != null) {
            if (listenerName.length() > 0) {
                listenerName.append('.');
            }
            listenerName.append(lToken);
            String string2 = lToken = stListener.hasMoreTokens() ? stListener.nextToken() : null;
        }
        while (lToken != null) {
            LogicModelItem lmi = logicModel.get(listenerName.toString().replace('#', '.'));
            if (lmi instanceof LogicModelItem.TableItem) {
                listenerName.append('#');
            } else {
                listenerName.append('.');
            }
            listenerName.append(lToken);
            lToken = stListener.hasMoreTokens() ? stListener.nextToken() : null;
        }
        while (rToken != null) {
            if (referenceName.length() > 0) {
                referenceName.append('.');
            }
            referenceName.append(rToken);
            String string3 = rToken = stReference.hasMoreTokens() ? stReference.nextToken() : null;
            if (referenceIntoTables || rToken == null || !(logicModel.get(EngineUtil.removeTableIndices(referenceName.toString())) instanceof LogicModelItem.TableItem)) continue;
            throw new InvalidModelException("invalid reference into table (" + this.name + ") in " + logicModelItem.getName());
        }
        this.reference = logicModel.get(referenceName.toString());
        if (this.reference == null) {
            throw new InvalidModelException("invalid reference (" + this.name + ") in " + logicModelItem.getName());
        }
        return listenerName.toString();
    }

    public LogicModelItem getReference() {
        return this.reference;
    }

    public void registerListenerOnReference(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem, boolean referenceIntoTables) throws InvalidModelException {
        String listenerName = this.initializeReference(logicModel, logicModelItem, referenceIntoTables);
        if (listenerName.indexOf(35) != -1) {
            this.reference.addDataModelListener(new TableDataChangeListener(listenerName, logicModelItem));
        } else {
            this.reference.addDataModelListener(logicModelItem);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.name).append("relativeReference", this.relativeReference).append("reference", (Object)(this.reference == null ? "null" : this.reference.getName())).build();
    }

    private class TableDataChangeListener
    implements ModelChangeListener {
        private final String keyWithHash;
        private final LogicModelItem item;

        public TableDataChangeListener(String keyWithHash, LogicModelItem item) {
            this.keyWithHash = keyWithHash;
            this.item = item;
        }

        @Override
        public void dataChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
            ArrayList<String> elements = new ArrayList<String>();
            this.substituteHashes(dataModel, elements, EngineUtil.mergeModelKey(this.keyWithHash, dataModelKey));
            for (String element : elements) {
                this.item.dataChanged(dataModel, element, oldValue, newValue, changedEventsOnlyOutsideOfThisTable);
            }
        }

        private void substituteHashes(LogicModelItem.ProtectedMap dataModel, List<String> keys, String key) {
            int p = key.indexOf(35);
            if (p != -1) {
                ModelItemDTO mi = dataModel.get(key.substring(0, p));
                if (mi != null && mi.getValue() != null) {
                    for (Object entry : (Collection)mi.getValue()) {
                        this.substituteHashes(dataModel, keys, key.substring(0, p) + "." + String.valueOf(entry) + "." + key.substring(p + 1));
                    }
                }
            } else {
                keys.add(key);
            }
        }

        @Override
        public void stateChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        }

        @Override
        public @NonNull String getName() {
            return Reference.this.name;
        }
    }
}

