/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.util.Resource;
import ch.dvbern.tax.common.engine.util.ResourceProvider;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class DataResourceBase
implements DataResource {
    public static final Charset RESOURCES_CHARSET = Charset.forName("UTF-8");
    public static final String BARCODE = "barcode";
    public static final String CONSTANTS = "constants";
    private final Map<String, Map<?, ?>> cache = new ConcurrentHashMap();
    private final ResourceProvider resourceProvider;

    public DataResourceBase(@NonNull ResourceProvider resourceProvider) {
        if (resourceProvider == null) {
            throw new NullPointerException("Resource provider cannot be null.");
        }
        this.resourceProvider = resourceProvider;
    }

    @Override
    public @NonNull Map<?, ?> get(@NonNull String code, Object arg1, Object arg2) {
        if (code == null) {
            throw new NullPointerException("Resource code cannot be null.");
        }
        return this.getResourceMap(code, arg1, arg2);
    }

    private Map<?, ?> getResourceMap(String code, Object ... args) {
        int indirectionLevel;
        assert (code != null);
        Map map = this.cache.get(code);
        Resource resource = this.getResource(code);
        if (map == null) {
            resource = this.getResource(code);
            try {
                map = resource.parse(this.resourceProvider);
            }
            catch (Exception e) {
                throw new ApplicationException("Failed process resource: " + code, e);
            }
            this.cache.put(code, Collections.unmodifiableMap(map));
        }
        if ((indirectionLevel = resource.getIndirectionLevelCount()) > 2) {
            throw new ApplicationException("Cannot process resource, too many indirection level: " + code);
        }
        for (int i = 0; i < resource.getIndirectionLevelCount(); ++i) {
            Object arg = args[i];
            if (arg == null) {
                return Collections.emptyMap();
            }
            map = (Map)map.get(arg);
        }
        return map;
    }

    protected abstract @NonNull Resource getResource(String var1);

    public static class XMLFactory
    implements ElementParser {
        private final @Nullable DataResource dataResource;

        public XMLFactory(@Nullable DataResource dataResource) {
            this.dataResource = dataResource;
        }

        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            return new ClassObjectPair(DataResource.class, (Object)this.dataResource);
        }
    }
}

