/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.dvbtax.esteuerauszugextractor.dto;

import ch.dvbern.dvbtax.esteuerauszugextractor.dto.LiabilityAccount;
import java.math.BigDecimal;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Schulden {
    private @Nullable BigDecimal totalTaxValue;
    private @Nullable BigDecimal totalGrossRevenueB;
    private @Nullable List<LiabilityAccount> liabilityAccounts;

    public @Nullable BigDecimal getTotalTaxValue() {
        return this.totalTaxValue;
    }

    public @Nullable BigDecimal getTotalGrossRevenueB() {
        return this.totalGrossRevenueB;
    }

    public @Nullable List<LiabilityAccount> getLiabilityAccounts() {
        return this.liabilityAccounts;
    }

    public static final class Builder {
        private @Nullable BigDecimal totalTaxValue;
        private @Nullable BigDecimal totalGrossRevenueB;
        private @Nullable List<LiabilityAccount> liabilityAccounts;

        private Builder() {
        }

        public static Builder getInstance() {
            return new Builder();
        }

        public @NonNull Builder withTotalTaxValue(BigDecimal val) {
            this.totalTaxValue = val;
            return this;
        }

        public @NonNull Builder withTotalGrossRevenueB(BigDecimal val) {
            this.totalGrossRevenueB = val;
            return this;
        }

        public @NonNull Builder withLiabilityAccounts(List<LiabilityAccount> val) {
            this.liabilityAccounts = val;
            return this;
        }

        public @NonNull Schulden build() {
            Schulden schulden = new Schulden();
            schulden.totalTaxValue = this.totalTaxValue;
            schulden.liabilityAccounts = this.liabilityAccounts;
            schulden.totalGrossRevenueB = this.totalGrossRevenueB;
            return schulden;
        }
    }
}

