/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.dvbtax.esteuerauszugextractor;

import ch.dvbern.dvbtax.esteuerauszugextractor.ExtractorUtil;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Steuerauszug;
import ch.dvbern.dvbtax.esteuerauszugextractor.exception.ErrorCode;
import ch.dvbern.dvbtax.esteuerauszugextractor.exception.ExtractionException;
import ch.dvbern.dvbtax.esteuerauszugextractor.util.SteuerauszugMapper;
import ch.dvbern.lib.esteuerauszug.ERFException;
import ch.dvbern.lib.esteuerauszug.ERFUtils;
import ch.ewv.taxstatement.TaxStatement;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Extractor {
    private static final JAXBContext JAXB_CONTEXT;
    private static final Logger LOG;
    private static final byte[] PDF_MAGIC_NUMBER;
    private static final String NS_XML_DSIG = "http://www.w3.org/2000/09/xmldsig#";
    private static final String LN_SIGNATURE = "Signature";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] pdfToXml(byte[] pdf) throws ExtractionException {
        this.checkPdfFileType(pdf);
        try (ByteArrayInputStream bis = new ByteArrayInputStream(pdf);){
            byte[] xml;
            byte[] byArray = xml = ERFUtils.extractEmbeddedXml((InputStream)bis);
            return byArray;
        }
        catch (ERFException | IOException e) {
            throw new ExtractionException(ErrorCode.INTERNAL_ERROR, e);
        }
    }

    private void checkPdfFileType(byte[] content) throws ExtractionException {
        byte[] bytes = Arrays.copyOf(content, 1024);
        int index = ExtractorUtil.indexOf(bytes, PDF_MAGIC_NUMBER);
        if (index < 0) {
            throw new ExtractionException(ErrorCode.WRONG_FILE_TYPE);
        }
    }

    public @NonNull ch.ech.xmlns.ech_0196._2.TaxStatement xmlToTaxStatement(byte[] xml) throws ExtractionException {
        this.verifySignature(xml);
        ch.ech.xmlns.ech_0196._2.TaxStatement ts = this.parseTaxStatement(xml);
        return ts;
    }

    private void verifySignature(byte[] xml) {
        try {
            boolean signed = this.hasDigitalSignature(xml);
            if (!signed) {
                return;
            }
            boolean signatureValid = TaxStatement.verifyXML((byte[])xml);
            if (!signatureValid) {
                throw new ExtractionException(ErrorCode.INVALID_DIGITAL_SIGNATURE);
            }
        }
        catch (Exception e) {
            throw new ExtractionException(ErrorCode.INTERNAL_ERROR);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ch.ech.xmlns.ech_0196._2.TaxStatement parseTaxStatement(byte[] xml) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(xml);){
            Unmarshaller um = JAXB_CONTEXT.createUnmarshaller();
            ch.ech.xmlns.ech_0196._2.TaxStatement ts = (ch.ech.xmlns.ech_0196._2.TaxStatement)um.unmarshal((InputStream)is);
            if (!TaxStatement.validateXML((byte[])xml)) {
                throw new ExtractionException(ErrorCode.INVALID_XML, null);
            }
            ch.ech.xmlns.ech_0196._2.TaxStatement taxStatement = ts;
            return taxStatement;
        }
        catch (JAXBException | XPathExpressionException e) {
            throw new ExtractionException(ErrorCode.INVALID_XML, e);
        }
        catch (IOException | ParseException | ParserConfigurationException | SAXException e) {
            throw new ExtractionException(ErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    private boolean hasDigitalSignature(byte[] xml) throws ParserConfigurationException, IOException, SAXException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(xml);){
            boolean hasSignature;
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            NodeList signatureNodes = document.getElementsByTagNameNS(NS_XML_DSIG, LN_SIGNATURE);
            boolean bl = hasSignature = signatureNodes != null && signatureNodes.item(0) != null;
            return bl;
        }
    }

    public @NonNull Steuerauszug getSteuerauszug(byte[] xml) throws ExtractionException {
        ch.ech.xmlns.ech_0196._2.TaxStatement taxStatement = this.xmlToTaxStatement(xml);
        return SteuerauszugMapper.createSteuerauszug(taxStatement);
    }

    private BufferedImage[] createBarcodeFromXml(byte[] xml) {
        BufferedImage[] barcodes = null;
        try {
            barcodes = TaxStatement.barCodeXML((byte[])xml);
        }
        catch (IOException | ParseException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            LOG.error("Failed to create barcodes from xml. Invalid xml", (Throwable)e);
        }
        return barcodes;
    }

    public byte[] xmlToPdf(byte[] xml) {
        BufferedImage[] images = this.createBarcodeFromXml(xml);
        return this.barcodesToPdf(images);
    }

    /*
     * Exception decompiling
     */
    private byte[] barcodesToPdf(BufferedImage[] img) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] taxStatementToXML(ch.ech.xmlns.ech_0196._2.TaxStatement taxStatement) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Marshaller marshaller = JAXB_CONTEXT.createMarshaller();
            marshaller.marshal((Object)taxStatement, (OutputStream)os);
            byte[] xml = os.toByteArray();
            if (!TaxStatement.validateXML((byte[])xml)) {
                throw new ExtractionException(ErrorCode.INVALID_XML, null);
            }
            byte[] byArray = xml;
            return byArray;
        }
        catch (JAXBException | XPathExpressionException e) {
            throw new ExtractionException(ErrorCode.INVALID_XML, e);
        }
        catch (IOException | ParseException | ParserConfigurationException | SAXException e) {
            throw new ExtractionException(ErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public byte[] taxStatementToPdf(ch.ech.xmlns.ech_0196._2.TaxStatement statement) {
        return this.xmlToPdf(this.taxStatementToXML(statement));
    }

    static {
        LOG = LoggerFactory.getLogger(Extractor.class);
        PDF_MAGIC_NUMBER = "%PDF".getBytes();
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{ch.ech.xmlns.ech_0196._2.TaxStatement.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Could not init Extractor", e);
        }
    }
}

