/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.vision.barcode.pdf417.rs;

import com.java4less.vision.barcode.pdf417.rs.GFPolynomial;
import com.java4less.vision.barcode.pdf417.rs.GField;

public class PDF417RS {
    int prime = 929;
    int[] alphaTo = new int[this.prime + 1];
    int[] indexOf = new int[this.prime + 1];
    GField gf;

    public PDF417RS() {
        this.gf = new GField(929, 3);
    }

    public PDF417RS(int mm, int eleCount, int[] pp) {
        this.gf = new GField(eleCount, 2, mm, pp);
    }

    public int decode(int[] rec, int ecLen) {
        int i;
        int i2;
        int ARRAYSIZE = rec.length + 1;
        int[] lambdaVector = new int[ARRAYSIZE];
        int[] B = new int[ARRAYSIZE];
        int[] S2 = new int[ecLen + 1];
        boolean error = false;
        for (int i3 = 1; i3 <= ecLen; ++i3) {
            S2[i3] = 0;
        }
        int[] irec = new int[rec.length];
        for (int i4 = 0; i4 < rec.length; ++i4) {
            irec[i4] = rec[rec.length - (i4 + 1)];
        }
        GFPolynomial dataPol = new GFPolynomial(irec, this.gf);
        for (i2 = 1; i2 <= ecLen; ++i2) {
            S2[i2] = dataPol.eval(this.gf.alphaTo[i2]);
        }
        for (i2 = 1; i2 <= ecLen; ++i2) {
            if (S2[i2] == 0) continue;
            error = true;
        }
        if (!error) {
            System.out.println("No errors detected");
            return 0;
        }
        lambdaVector = new int[ecLen + 1];
        for (i2 = 1; i2 <= ecLen; ++i2) {
            lambdaVector[i2] = 0;
        }
        lambdaVector[0] = 1;
        GFPolynomial lambdaPoly = new GFPolynomial(lambdaVector, this.gf);
        B = new int[ecLen + 1];
        for (int i5 = 1; i5 <= ecLen; ++i5) {
            B[i5] = 0;
        }
        B[0] = 1;
        GFPolynomial BPoly = new GFPolynomial(B, this.gf);
        int stepR = 0;
        int L = 0;
        do {
            ++stepR;
            int discR = 0;
            for (int j = 0; j <= L; ++j) {
                if (lambdaPoly.getCoefficient(j) == 0 || S2[stepR - j] == 0) continue;
                discR = this.gf.add(discR, this.gf.mult(lambdaPoly.getCoefficient(j), S2[stepR - j]));
            }
            if (discR == 0) {
                BPoly.multX();
                continue;
            }
            GFPolynomial xB = BPoly.copy();
            xB.multX();
            GFPolynomial TPoly = lambdaPoly.copy();
            for (i = 0; i <= ecLen; ++i) {
                if (xB.getCoefficient(i) == 0) continue;
                TPoly.setCoefficient(i, this.gf.substract(lambdaPoly.getCoefficient(i), this.gf.mult(discR, xB.getCoefficient(i))));
            }
            if (2 * L <= stepR - 1) {
                for (i = 0; i <= ecLen; ++i) {
                    if (lambdaPoly.getCoefficient(i) == 0) {
                        BPoly.setCoefficient(i, 0);
                        continue;
                    }
                    BPoly.setCoefficient(i, this.gf.div(lambdaPoly.getCoefficient(i), discR));
                }
                lambdaPoly = TPoly.copy();
                L = stepR - L;
                continue;
            }
            lambdaPoly = TPoly.copy();
            BPoly.multX();
        } while (stepR != ecLen);
        if (lambdaPoly.getDegree() != L) {
            System.out.println("Berlekamp-Massey returned too many errors");
            return -1;
        }
        int roots = 0;
        int[] rootValues = new int[this.prime];
        int[] locations = new int[this.prime];
        for (i = 1; i <= this.prime; ++i) {
            int result = lambdaPoly.eval(i);
            if (result != 0) continue;
            rootValues[roots] = i;
            locations[roots] = this.prime - 1 - this.gf.indexOf[i];
            ++roots;
        }
        if (lambdaPoly.getDegree() != roots) {
            System.out.println("Berlekamp-Massey returned wrong number of roots " + lambdaPoly.getDegree() + "!=" + roots);
            return -1;
        }
        GFPolynomial SPoly = new GFPolynomial(S2, this.gf);
        GFPolynomial omegaPoly = SPoly.multMod(lambdaPoly, ecLen);
        for (int j = roots - 1; j >= 0; --j) {
            int n1 = omegaPoly.eval(rootValues[j]);
            int n3 = 1;
            for (int k = 0; k < roots; ++k) {
                if (k == j) continue;
                int t = (1 + this.prime - this.gf.div(rootValues[j], rootValues[k])) % this.prime;
                n3 = this.gf.mult(n3, t);
            }
            if (n3 == 0) {
                return -1;
            }
            int errorVal = this.gf.div(n1, n3);
            if (n1 == 0 || locations[j] >= irec.length + 1) continue;
            irec[locations[j]] = this.gf.substract(irec[locations[j]], errorVal);
            rec[rec.length - (locations[j] + 1)] = irec[locations[j]];
        }
        return roots;
    }
}

