/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.vision.barcode.pdf417.rs;

public class GField {
    int prime = 0;
    int alpha = 0;
    int mm = 0;
    int[] alphaTo = new int[this.prime + 1];
    int[] indexOf = new int[this.prime + 1];

    public GField(int c, int a) {
        this.alphaTo = new int[this.prime + 1];
        this.indexOf = new int[this.prime + 1];
        this.prime = c;
        this.alpha = a;
        this.mm = c;
        this.init3();
    }

    public GField(int c, int a, int m, int[] p) {
        this.alphaTo = new int[this.prime + 1];
        this.indexOf = new int[this.prime + 1];
        this.prime = c;
        this.alpha = a;
        this.mm = m;
        this.init2(p);
    }

    private void init2(int[] pp) {
        int i = 0;
        this.alphaTo = new int[this.prime + 1];
        this.indexOf = new int[this.prime + 1];
        int mask = 1;
        this.alphaTo[this.mm] = 0;
        for (i = 0; i < this.mm; ++i) {
            this.alphaTo[i] = mask;
            this.indexOf[this.alphaTo[i]] = i;
            if (pp[i] != 0) {
                int n = this.mm;
                this.alphaTo[n] = this.alphaTo[n] ^ mask;
            }
            mask <<= 1;
        }
        this.indexOf[this.alphaTo[this.mm]] = this.mm;
        mask >>= 1;
        for (i = this.mm + 1; i < this.prime - 1; ++i) {
            this.alphaTo[i] = this.alphaTo[i - 1] >= mask ? this.alphaTo[this.mm] ^ (this.alphaTo[i - 1] ^ mask) << 1 : this.alphaTo[i - 1] << 1;
            this.indexOf[this.alphaTo[i]] = i;
        }
        this.indexOf[0] = this.prime - 1;
        this.indexOf[this.indexOf.length - 1] = this.prime - 1;
        this.alphaTo[this.alphaTo.length - 1] = 1;
    }

    private void init3() {
        this.alphaTo = new int[this.prime + 1];
        this.indexOf = new int[this.prime + 1];
        int i = 0;
        int p3 = 1;
        this.indexOf[1] = this.prime - 1;
        i = 0;
        while (i < this.prime - 1) {
            this.alphaTo[i] = p3;
            this.indexOf[p3] = i++;
            p3 = p3 * 3 % this.prime;
        }
        this.indexOf[0] = 928;
        this.indexOf[this.indexOf.length - 1] = 928;
        this.alphaTo[this.alphaTo.length - 1] = 1;
    }

    public int getCardinality() {
        return this.prime;
    }

    public int add(int a, int b) {
        if (this.alpha == 2) {
            return a ^ b;
        }
        return (a + b) % this.prime;
    }

    public int substract(int a, int b) {
        if (this.alpha == 2) {
            return a ^ b;
        }
        int result = (a - b) % this.prime;
        if (result < 0) {
            result += this.prime;
        }
        return result;
    }

    public int mult(int a, int b) {
        if (a == 0 || b == 0) {
            return 0;
        }
        return this.alphaTo[(this.indexOf[a] + this.indexOf[b]) % (this.prime - 1)];
    }

    public int neg(int x) {
        return this.substract(0, x);
    }

    public int div(int a, int b) {
        int result = (this.indexOf[a] - this.indexOf[b]) % (this.prime - 1);
        if (result < 0) {
            result = result + this.prime - 1;
        }
        return this.alphaTo[result];
    }
}

