/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.vision.barcode.pdf417.rs;

import com.java4less.vision.barcode.pdf417.rs.GField;

public class GFPolynomial {
    private int[] coefficients;
    private GField gf;

    public GFPolynomial(int[] c, GField field) {
        this.gf = field;
        this.coefficients = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            this.coefficients[i] = c[i];
        }
    }

    public int eval(int xval) {
        int res = this.coefficients[0];
        int xp = 0;
        for (int i = 1; i < this.length(); ++i) {
            if (i == 1) {
                xp = xval;
            }
            if (i > 1) {
                xp = this.gf.mult(xp, xval);
            }
            if (this.coefficients[i] <= 0) continue;
            int p = this.gf.mult(xp, this.coefficients[i]);
            res = this.gf.add(res, p);
        }
        return res;
    }

    public void multX() {
        for (int i = this.coefficients.length - 2; i >= 0; --i) {
            this.coefficients[i + 1] = this.coefficients[i];
        }
        this.coefficients[0] = 0;
    }

    public int length() {
        return this.coefficients.length;
    }

    public int getDegree() {
        int degree = 0;
        for (int i = 0; i < this.length(); ++i) {
            if (this.coefficients[i] == 0) continue;
            degree = i;
        }
        return degree;
    }

    public int getCoefficient(int pos) {
        if (pos >= this.coefficients.length) {
            return 0;
        }
        return this.coefficients[pos];
    }

    public void setCoefficient(int pos, int v) {
        if (pos >= this.coefficients.length) {
            return;
        }
        this.coefficients[pos] = v;
    }

    public GFPolynomial copy() {
        int[] coefficients2 = new int[this.coefficients.length];
        for (int i = 0; i < this.coefficients.length; ++i) {
            coefficients2[i] = this.coefficients[i];
        }
        return new GFPolynomial(coefficients2, this.gf);
    }

    public GFPolynomial multMod(GFPolynomial p, int b) {
        int[] coeff = new int[b + 1];
        for (int i = 0; i <= b; ++i) {
            int coe = 0;
            for (int j = i; j >= 0; --j) {
                coe = this.gf.add(coe, this.gf.mult(this.getCoefficient(i - j), p.getCoefficient(j)));
            }
            coeff[i % (this.gf.prime - 1)] = this.gf.add(coe, coeff[i % (this.gf.prime - 1)]);
        }
        return new GFPolynomial(coeff, this.gf);
    }

    public GFPolynomial mult(GFPolynomial p) {
        int len = this.length() + p.length();
        int[] coeff = new int[len + 1];
        for (int i = 0; i <= len; ++i) {
            int coe = 0;
            for (int j = i; j >= 0; --j) {
                coe = this.gf.add(coe, this.gf.mult(this.getCoefficient(i - j), p.getCoefficient(j)));
            }
            coeff[i % (this.gf.prime - 1)] = this.gf.add(coe, coeff[i % (this.gf.prime - 1)]);
        }
        return new GFPolynomial(coeff, this.gf);
    }
}

