/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.utils;

import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUIDException
extends ImportException {
    private static final long serialVersionUID = 3258690987977879609L;
    private static final Logger LOG = LoggerFactory.getLogger(UUIDException.class);
    private Object[] args;

    public UUIDException() {
    }

    public UUIDException(String message, String extraInfo) {
        super(message);
        String uuid = UUID.randomUUID().toString();
        this.setArgs(uuid);
        LOG.error(SharedUtils.translate(message, uuid) + extraInfo);
    }

    public UUIDException(String message) {
        super(message);
        String uuid = UUID.randomUUID().toString();
        this.setArgs(uuid);
        LOG.error(SharedUtils.translate(message, uuid));
    }

    private void setArgs(Object ... args) {
        this.args = args;
    }

    public @Nullable Object[] getMessageArgs() {
        return this.args;
    }
}

