/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.utils;

import ch.dvbern.tax.common.engine.util.ResourceProvider;
import ch.dvbern.tax.ge.pp.repartition.RepartitionDataSourceProvider;
import ch.dvbern.tax.ge.pp.utils.InternalFailureException;
import ch.dvbern.tax.ge.pp.utils.ServiceFactoryProvider;
import java.util.ServiceLoader;

public abstract class ServiceFactory {
    private static final ServiceFactory INSTANCE;

    public static ServiceFactory getInstance() {
        return INSTANCE;
    }

    public abstract RepartitionDataSourceProvider newRepartitionDataSourceProvider();

    public abstract ResourceProvider newDataResourceReader();

    static {
        ServiceLoader<ServiceFactoryProvider> loader = ServiceLoader.load(ServiceFactoryProvider.class);
        ServiceFactory instance = null;
        for (ServiceFactoryProvider provider : loader) {
            ServiceFactory candidate = provider.getServiceRegistry();
            if (candidate == null) continue;
            if (instance == null) {
                instance = candidate;
                continue;
            }
            throw new InternalFailureException("Multiple service registry available: " + String.valueOf(instance) + " / " + String.valueOf(candidate));
        }
        if (instance == null) {
            throw new InternalFailureException("No service registry available.");
        }
        INSTANCE = instance;
    }
}

