/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.utils;

import ch.dvbern.tax.common.engine.util.Resource;
import ch.dvbern.tax.common.engine.util.ResourceLineIterator;
import ch.dvbern.tax.common.engine.util.ResourceProvider;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.intercommunale.CentimesAdditionnelsPartPrivilegieeItem;
import ch.dvbern.tax.ge.pp.transfer.dto.AssurancesMaladieDTO;
import ch.dvbern.tax.ge.pp.transfer.dto.BaremeDTO;
import ch.dvbern.tax.ge.pp.transfer.dto.CommuneDTO;
import ch.dvbern.tax.ge.pp.transfer.dto.DeductionDTO;
import ch.dvbern.tax.ge.pp.transfer.dto.EgliseDTO;
import ch.dvbern.tax.ge.pp.transfer.dto.TravauxImmeublesDTO;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ResourceEnum
extends Enum<ResourceEnum>
implements Resource {
    public static final /* enum */ ResourceEnum CANTONS = new ResourceEnum("cantons"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, ResourceEnum.FILE_CANTONS, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String key = tokens[0];
                    String kurzBezeichnung = tokens[1];
                    String bezeichnung = tokens[2];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)kurzBezeichnung, key, bezeichnung, false);
                    map.put(kurzBezeichnung, optionItemDTO);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum PAYS = new ResourceEnum("pays"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(2);
                    String ofsNumber = tokens[0];
                    String name = tokens[1];
                    map.put(ofsNumber, new OptionItemDTO((Object)ofsNumber, name, name, false));
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum LIST_CURRENCY = new ResourceEnum("listCurrency"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(4);
                    String key = tokens[2];
                    String value = key + " " + tokens[3] + " - " + tokens[0];
                    map.put(key, new OptionItemDTO((Object)key, value, value, false));
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum TAUX_CHANGE_FORTUNE = new ResourceEnum("tauxChangeFortune"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(6);
                    String key = tokens[2];
                    double fortune = Double.parseDouble(tokens[5]);
                    double taux = Double.parseDouble(tokens[4]);
                    map.put(key, new SharedUtils.Currency(taux, fortune, key));
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum PAYS_ETRANGERS = new ResourceEnum("paysEtrangers"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(2);
                    String ofsNumber = tokens[0];
                    String name = tokens[1];
                    map.put(ofsNumber, new OptionItemDTO((Object)ofsNumber, name, name, false));
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum COMMUNESGE_CANTONS_PAYS = new ResourceEnum("communesGECantonsPays"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, ResourceEnum.FILE_COMMUNES, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String ofsNumber = tokens[0];
                    String canton = tokens[2];
                    if (!ResourceEnum.GENEVA_CANTON_CODE.equals(canton)) continue;
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)Long.valueOf(ofsNumber), ofsNumber, tokens[1], false);
                    map.put(ofsNumber, optionItemDTO);
                }
            });
            this.processResource(resourceProvider, ResourceEnum.FILE_CANTONS, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String ofsNumber = tokens[0];
                    String canton = tokens[1];
                    if (ResourceEnum.GENEVA_CANTON_CODE.equals(canton) || ResourceEnum.FOREIGN_COUNTRY_CODE.equals(canton)) continue;
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)Long.valueOf(ofsNumber), ofsNumber, tokens[2], false);
                    map.put(ofsNumber, optionItemDTO);
                }
            });
            this.processResource(resourceProvider, ResourceEnum.FILE_PAYS, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(2);
                    String ofsNumber = tokens[0];
                    if (ResourceEnum.SWITZERLAND_OFS_NUMBER.equals(ofsNumber)) continue;
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)Long.valueOf(ofsNumber), ofsNumber, tokens[1], false);
                    map.put(ofsNumber, optionItemDTO);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum COMMUNESGE_AVEC_CANTON = new ResourceEnum("communesGEavecCanton"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, ResourceEnum.FILE_COMMUNES, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String ofsNumber = tokens[0];
                    String canton = tokens[2];
                    if (!ResourceEnum.GENEVA_CANTON_CODE.equals(canton)) continue;
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)Long.valueOf(ofsNumber), ofsNumber, tokens[1], false);
                    map.put(ofsNumber, optionItemDTO);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum TAUX_CAPITALISATION = new ResourceEnum("tauxCapitalisation"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, ResourceEnum.FILE_TAUX_CAPITALISATION, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    Long value = Long.valueOf(tokens[0]);
                    String description = tokens[2];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)value, " ", description, false);
                    map.put(String.valueOf(value), optionItemDTO);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum IMMEUBLES_TRAVAUX_CATEGORIE = new ResourceEnum("immeublesTravauxCategorie"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, ResourceEnum.FILE_IMMEUBLES_TRAVAUX_CATEGORIE, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(2);
                    String enumeration = tokens[0];
                    String description = tokens[1];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)enumeration, description, description, false);
                    map.put(enumeration, optionItemDTO);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum IMMEUBLES_TRAVAUX_SOUS_CATEGORIE = new ResourceEnum("immeublesTravauxSousCategorie"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, ResourceEnum.FILE_IMMEUBLES_TRAVAUX_SOUS_CATEGORIE, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String categorie = tokens[0];
                    String enumeration = tokens[1];
                    String description = tokens[2];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)enumeration, description, description, false);
                    LinkedHashMap<String, OptionItemDTO> entriesOfSameCategory = (LinkedHashMap<String, OptionItemDTO>)map.get(categorie);
                    if (entriesOfSameCategory == null) {
                        entriesOfSameCategory = new LinkedHashMap<String, OptionItemDTO>();
                        map.put(categorie, entriesOfSameCategory);
                    }
                    entriesOfSameCategory.put(enumeration, optionItemDTO);
                }
            });
            return map;
        }

        @Override
        boolean isIndirect() {
            return true;
        }
    };
    public static final /* enum */ ResourceEnum IMMEUBLES_TRAVAUX_DETAIL = new ResourceEnum("immeublesTravauxDetail"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, "immeublesTravauxDetail", itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(5);
                    String categorie = tokens[0];
                    String enumeration = tokens[1];
                    TravauxImmeublesDTO.TypeFrais typeFrais = TravauxImmeublesDTO.TypeFrais.valueOf(tokens[2]);
                    String titre = tokens[3];
                    String description = tokens[4];
                    String optionItemFullText = StringUtils.isBlank((CharSequence)titre) ? description : titre + ": " + description;
                    TravauxImmeublesDTO optionItemDTO = new TravauxImmeublesDTO(enumeration, description, optionItemFullText, false, typeFrais);
                    LinkedHashMap<String, TravauxImmeublesDTO> entriesOfSameCategory = (LinkedHashMap<String, TravauxImmeublesDTO>)map.get(categorie);
                    if (entriesOfSameCategory == null) {
                        entriesOfSameCategory = new LinkedHashMap<String, TravauxImmeublesDTO>();
                        map.put(categorie, entriesOfSameCategory);
                    }
                    entriesOfSameCategory.put(enumeration, optionItemDTO);
                }
            });
            return map;
        }

        @Override
        boolean isIndirect() {
            return true;
        }
    };
    public static final /* enum */ ResourceEnum IMMEUBLES_TRAVAUX_DETAIL_FULL = new ResourceEnum("immeublesTravauxDetailFull"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            LinkedHashMap fullMap = new LinkedHashMap();
            this.processResource(resourceProvider, "immeublesTravauxDetail", itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(5);
                    String categorie = tokens[0];
                    String enumeration = tokens[1];
                    TravauxImmeublesDTO.TypeFrais typeFrais = TravauxImmeublesDTO.TypeFrais.valueOf(tokens[2]);
                    String titre = tokens[3];
                    String description = tokens[4];
                    String optionItemFullText = StringUtils.isBlank((CharSequence)titre) ? description : titre + ": " + description;
                    TravauxImmeublesDTO optionItemDTO = new TravauxImmeublesDTO(enumeration, description, optionItemFullText, false, typeFrais);
                    fullMap.put(optionItemDTO.getText().toString(), optionItemDTO);
                }
            });
            return fullMap;
        }
    };
    public static final /* enum */ ResourceEnum PAYS_DA1 = new ResourceEnum("paysDa1"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(2);
                    String key = tokens[0];
                    String bezeichnung = tokens[1];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)key, null, bezeichnung, false);
                    map.put(key, optionItemDTO);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum PAYS_ENFANT = new ResourceEnum("paysEnfant"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(2);
                    String key = tokens[0];
                    String bezeichnung = tokens[1];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)key, null, bezeichnung, false);
                    map.put(key, optionItemDTO);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum CONFIGURATIONS = new ResourceEnum("configurations"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            return this.buildSimpleMap(resourceProvider);
        }
    };
    public static final /* enum */ ResourceEnum SHORT_HELP_MAPPING = new ResourceEnum("shortHelpMapping"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            return this.buildSimpleMap(resourceProvider);
        }
    };
    public static final /* enum */ ResourceEnum LINKS = new ResourceEnum("links"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            return this.buildSimpleMap(resourceProvider);
        }
    };
    public static final /* enum */ ResourceEnum COMMUNES_GENEVE = new ResourceEnum("communesGeneve"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, ResourceEnum.FILE_COMMUNES_GENEVE, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(4);
                    Long communeCadastrale = Long.valueOf(tokens[0]);
                    String sCodeCommune = tokens[1];
                    String kurzBezeichnung = tokens[2];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)communeCadastrale, sCodeCommune, kurzBezeichnung, false);
                    map.put(communeCadastrale.toString(), optionItemDTO);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum PARCELLES = new ResourceEnum("parcelles"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                TreeSet<Integer> parcellesCommune = new TreeSet<Integer>();
                Integer currentCommune = 1;
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(ResourceEnum.SEMICOLON, 2);
                    Integer communeCadastrale = Integer.valueOf(tokens[0]);
                    Integer parcelle = Integer.valueOf(tokens[1]);
                    if (!currentCommune.equals(communeCadastrale)) {
                        map.put(currentCommune, parcellesCommune);
                        currentCommune = communeCadastrale;
                        parcellesCommune = new TreeSet();
                    }
                    parcellesCommune.add(parcelle);
                }
                map.put(currentCommune, parcellesCommune);
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum COMMUNES_TOTAL = new ResourceEnum("communesTotal"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, ResourceEnum.FILE_COMMUNES, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String ofsNumber = tokens[0];
                    CommuneDTO dto = new CommuneDTO(Long.valueOf(ofsNumber), tokens[1], tokens[2]);
                    map.put(ofsNumber, dto);
                }
            });
            this.processResource(resourceProvider, ResourceEnum.FILE_PAYS, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(2);
                    String ofsNumber = tokens[0];
                    if (ResourceEnum.SWITZERLAND_OFS_NUMBER.equals(ofsNumber)) continue;
                    CommuneDTO dto = new CommuneDTO(Long.valueOf(ofsNumber), tokens[1], ResourceEnum.FOREIGN_COUNTRY_CODE);
                    map.put(ofsNumber, dto);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum SURESTIMATION_IMMEUBLES = new ResourceEnum("surestimationImmeubles"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            HashMap map = new HashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String key = tokens[0];
                    Long value = Long.valueOf(tokens[2]);
                    map.put(key, value);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum CANTONS_INDEX_SORTED = new ResourceEnum("cantons_index_sorted"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, ResourceEnum.FILE_CANTONS, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String key = tokens[0];
                    String kurzBezeichnung = tokens[1];
                    String bezeichnung = tokens[2];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)key, kurzBezeichnung, bezeichnung, false);
                    map.put(key, optionItemDTO);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum IMPOT_BASE_FORTUNE = new ResourceEnum("impotBaseFortune"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String montantDeterminant = tokens[0];
                    String impotAnnuel = tokens[1];
                    String par1000CHFSupp = tokens[2];
                    String values = impotAnnuel + "\t" + par1000CHFSupp;
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)montantDeterminant, null, values, false);
                    map.put(montantDeterminant, optionItemDTO);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum IMPOT_SUPPL_FORTUNE = new ResourceEnum("impotSupplFortune"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String montantDeterminant = tokens[0];
                    String impotAnnuel = tokens[1];
                    String par1000CHFSupp = tokens[2];
                    String values = impotAnnuel + "\t" + par1000CHFSupp;
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)montantDeterminant, null, values, false);
                    map.put(montantDeterminant, optionItemDTO);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum BAREME = new ResourceEnum("bareme"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            ArrayList tranches = new ArrayList(20);
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    long montantDeterminant = Long.parseLong(tokens[0]);
                    double taux = Double.parseDouble(tokens[1]) / 100.0;
                    double impotCumule = Double.parseDouble(tokens[2]);
                    tranches.add(new BaremeDTO(montantDeterminant, taux, impotCumule));
                }
            });
            return Collections.singletonMap(null, Collections.unmodifiableList(tranches));
        }
    };
    public static final /* enum */ ResourceEnum COMMUNES_PAR_CANTON = new ResourceEnum("communesParCanton"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, ResourceEnum.FILE_COMMUNES, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String ofsNumber = tokens[0];
                    String codeCanton = tokens[2];
                    CommuneDTO dto = new CommuneDTO(Long.valueOf(ofsNumber), tokens[1], codeCanton);
                    LinkedHashMap<String, CommuneDTO> communesDuCanton = (LinkedHashMap<String, CommuneDTO>)map.get(codeCanton);
                    if (communesDuCanton == null) {
                        communesDuCanton = new LinkedHashMap<String, CommuneDTO>();
                        map.put(codeCanton, communesDuCanton);
                    }
                    communesDuCanton.put(ofsNumber, dto);
                }
            });
            LinkedHashMap countries = new LinkedHashMap();
            map.put(ResourceEnum.FOREIGN_COUNTRY_CODE, countries);
            this.processResource(resourceProvider, ResourceEnum.FILE_PAYS, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(2);
                    String ofsNumber = tokens[0];
                    if (ResourceEnum.SWITZERLAND_OFS_NUMBER.equals(ofsNumber)) continue;
                    CommuneDTO dto = new CommuneDTO(Long.valueOf(ofsNumber), tokens[1], ResourceEnum.FOREIGN_COUNTRY_CODE);
                    countries.put(ofsNumber, dto);
                }
            });
            return map;
        }

        @Override
        boolean isIndirect() {
            return true;
        }
    };
    public static final /* enum */ ResourceEnum DEDUCTION_ASSURANCES_MALADIE = new ResourceEnum("deductionAssurancesMaladie"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(2);
                    Long age = Long.valueOf(tokens[0]);
                    Long deduction = Long.valueOf(tokens[1]);
                    AssurancesMaladieDTO dto = new AssurancesMaladieDTO(age, deduction);
                    map.put(age, dto);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum DEDUCTION_AVS_EINPERSONEN_HAUSHALT = new ResourceEnum("deductionAvsEinpersHaushalt"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(2);
                    Long revenuMax = Long.valueOf(tokens[0]);
                    Long deductionSimple = Long.valueOf(tokens[1]);
                    DeductionDTO deduction = new DeductionDTO(revenuMax, deductionSimple, null);
                    map.put(revenuMax, deduction);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum DEDUCTION_AVS_MEHRPERSONEN_HAUSHALT = new ResourceEnum("deductionAvsMehrpersHaushalt"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap deductionsAvsTemp = new LinkedHashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    Long revenuMax = Long.valueOf(tokens[0]);
                    Long deductionSimple = Long.valueOf(tokens[1]);
                    Long deductionMajoree = Long.valueOf(tokens[2]);
                    DeductionDTO deduction = new DeductionDTO(revenuMax, deductionSimple, deductionMajoree);
                    deductionsAvsTemp.put(revenuMax, deduction);
                }
            });
            return deductionsAvsTemp;
        }
    };
    public static final /* enum */ ResourceEnum IMPOT_IFD_MARIE = new ResourceEnum("impotIfdMarie"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(2);
                    String montantDeterminant = tokens[0];
                    String impotAnnuel = tokens[1];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)montantDeterminant, null, impotAnnuel, false);
                    map.put(montantDeterminant, optionItemDTO);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum IMPOT_IFD_CELIBATAIRE = new ResourceEnum("impotIfdCelibataire"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(2);
                    String montantDeterminant = tokens[0];
                    String impotAnnuel = tokens[1];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)montantDeterminant, null, impotAnnuel, false);
                    map.put(montantDeterminant, optionItemDTO);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum RESOURCES_TO_PRINT = new ResourceEnum("resourcesToPrint"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            return this.buildSimpleMap(resourceProvider);
        }
    };
    public static final /* enum */ ResourceEnum VALEUR_FISCALE_IMMEUBLE = new ResourceEnum("valeurFiscaleImmeuble"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, ResourceEnum.FILE_TAUX_CAPITALISATION, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    Long value = Long.valueOf(tokens[0]);
                    String description = tokens[1];
                    map.put(value, Double.valueOf(description));
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum VALEUR_IMMEUBLE_LOCATIVE = new ResourceEnum("immeublesValeurLocative"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, ResourceEnum.FILE_IMMEUBLES_VALEUR_LOCATIVE, itr -> {
                if (itr.hasNext()) {
                    String[] tokens = itr.splitNext(2);
                    Double value1 = Double.valueOf(tokens[0]);
                    Double value2 = Double.valueOf(tokens[1]);
                    map.put(value1, value2);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum CENTIMES_ADDITIONNELS = new ResourceEnum("centimesAdditionnels"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(4);
                    Long codeLieu = Long.valueOf(tokens[0]);
                    Double partPrivilegiee = Double.valueOf(tokens[2]);
                    Double sCentimesAddit = Double.valueOf(tokens[3]);
                    CentimesAdditionnelsPartPrivilegieeItem aItem = new CentimesAdditionnelsPartPrivilegieeItem(codeLieu, partPrivilegiee, sCentimesAddit);
                    map.put(codeLieu, aItem);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum TAUX_INTERETS_AVS = new ResourceEnum("tauxInteretsAVS"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            HashMap map = new HashMap();
            this.processResource(resourceProvider, this.code(), itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(2);
                    String key = tokens[0];
                    Double value = Double.valueOf(tokens[1]);
                    map.put(key, value);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum TYPE_DETTE = new ResourceEnum("typeDette"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, ResourceEnum.FILE_TYPE_DETTE, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String key = tokens[0];
                    String description = tokens[2];
                    String shortText = tokens[1];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)shortText, key, description, false);
                    map.put(shortText, optionItemDTO);
                }
            });
            return map;
        }
    };
    public static final /* enum */ ResourceEnum EGLISES = new ResourceEnum("eglises"){

        @Nonnull
        public Map<?, ?> parse(@Nonnull ResourceProvider resourceProvider) throws IOException {
            LinkedHashMap map = new LinkedHashMap();
            this.processResource(resourceProvider, ResourceEnum.FILE_EGLISES, itr -> {
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(5);
                    Long orCode = Long.valueOf(tokens[0]);
                    String orLibelle = tokens[1];
                    Double tcrOr = Double.valueOf(tokens[2]);
                    Double tcfOr = Double.valueOf(tokens[3]);
                    Double dpfOr = Double.valueOf(tokens[4]);
                    EgliseDTO optionItemDTO = new EgliseDTO(null, null, orLibelle, false, orCode, tcrOr, tcfOr, dpfOr);
                    map.put(orCode, optionItemDTO);
                }
            });
            return map;
        }
    };
    private static final SimpleDateFormat SDF;
    private static final String GENEVA_CANTON_CODE = "GE";
    public static final String FOREIGN_COUNTRY_CODE = "EX";
    private static final String SWITZERLAND_OFS_NUMBER = "8100";
    private static final String PROPERTIES_FILE_DELIMITER = "=";
    private static final String SEMICOLON = ";";
    private static final String FILE_COMMUNES_GENEVE = "communesGeneve";
    private static final String FILE_CANTONS = "cantons";
    private static final String FILE_COMMUNES = "communes";
    private static final String FILE_EGLISES = "eglises";
    private static final String FILE_PAYS = "pays";
    private static final String FILE_TAUX_CAPITALISATION = "tauxCapitalisation";
    private static final String FILE_IMMEUBLES_TRAVAUX_CATEGORIE = "immeublesTravauxCategorie";
    private static final String FILE_IMMEUBLES_TRAVAUX_SOUS_CATEGORIE = "immeublesTravauxSousCategorie";
    private static final String FILE_IMMEUBLES_TRAVAUX_DETAIL = "immeublesTravauxDetail";
    private static final String FILE_IMMEUBLES_TRAVAUX_DETAIL_FULL = "immeublesTravauxDetail";
    private static final String FILE_IMMEUBLES_VALEUR_LOCATIVE = "immeublesValeurLocative";
    private static final String FILE_TYPE_DETTE = "typeDette";
    private final String code;
    private static final /* synthetic */ ResourceEnum[] $VALUES;

    public static ResourceEnum[] values() {
        return (ResourceEnum[])$VALUES.clone();
    }

    public static ResourceEnum valueOf(String name) {
        return Enum.valueOf(ResourceEnum.class, name);
    }

    private ResourceEnum(String code) {
        assert (code != null);
        this.code = code;
    }

    public String code() {
        return this.code;
    }

    public int getIndirectionLevelCount() {
        return this.isIndirect() ? 1 : 0;
    }

    void processResource(ResourceProvider provider, String code, ParserDelegate delegate) {
        String fileName = code + ".txt";
        Reader reader = provider.getReader(fileName);
        ResourceLineIterator lineItr = null;
        try {
            lineItr = new ResourceLineIterator(reader);
            delegate.parse(lineItr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Parsing file %s failed at line %d.", fileName, lineItr == null ? 0 : lineItr.getLineNumber()), e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    boolean isIndirect() {
        return false;
    }

    Map<?, ?> buildSimpleMap(ResourceProvider provider) {
        LinkedHashMap map = new LinkedHashMap();
        this.processResource(provider, this.code(), itr -> {
            while (itr.hasNext()) {
                String[] tokens = itr.splitNext(PROPERTIES_FILE_DELIMITER, 2);
                String key = tokens[0];
                String bezeichnung = tokens[1];
                map.put(key, bezeichnung);
            }
        });
        return map;
    }

    public static ResourceEnum forCode(String code) {
        if (code == null) {
            throw new NullPointerException("Resource code cannot be null.");
        }
        for (ResourceEnum resource : ResourceEnum.values()) {
            if (!resource.code.equals(code)) continue;
            return resource;
        }
        throw new IllegalArgumentException(String.format("No resource with specified identifier: '%s'.", code));
    }

    private static /* synthetic */ ResourceEnum[] $values() {
        return new ResourceEnum[]{CANTONS, PAYS, LIST_CURRENCY, TAUX_CHANGE_FORTUNE, PAYS_ETRANGERS, COMMUNESGE_CANTONS_PAYS, COMMUNESGE_AVEC_CANTON, TAUX_CAPITALISATION, IMMEUBLES_TRAVAUX_CATEGORIE, IMMEUBLES_TRAVAUX_SOUS_CATEGORIE, IMMEUBLES_TRAVAUX_DETAIL, IMMEUBLES_TRAVAUX_DETAIL_FULL, PAYS_DA1, PAYS_ENFANT, CONFIGURATIONS, SHORT_HELP_MAPPING, LINKS, COMMUNES_GENEVE, PARCELLES, COMMUNES_TOTAL, SURESTIMATION_IMMEUBLES, CANTONS_INDEX_SORTED, IMPOT_BASE_FORTUNE, IMPOT_SUPPL_FORTUNE, BAREME, COMMUNES_PAR_CANTON, DEDUCTION_ASSURANCES_MALADIE, DEDUCTION_AVS_EINPERSONEN_HAUSHALT, DEDUCTION_AVS_MEHRPERSONEN_HAUSHALT, IMPOT_IFD_MARIE, IMPOT_IFD_CELIBATAIRE, RESOURCES_TO_PRINT, VALEUR_FISCALE_IMMEUBLE, VALEUR_IMMEUBLE_LOCATIVE, CENTIMES_ADDITIONNELS, TAUX_INTERETS_AVS, TYPE_DETTE, EGLISES};
    }

    static {
        $VALUES = ResourceEnum.$values();
        SDF = new SimpleDateFormat("dd.MM.yyyy");
        SDF.setTimeZone(ApplicationConfig.TIMEZONE);
    }

    private static interface ParserDelegate {
        public void parse(ResourceLineIterator var1);
    }
}

