/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.utils;

import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.transfer.dto.TravauxImmeublesDTO;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ImmeublesTravauxSearchHelper {
    private final DvbTaxSession session;

    public ImmeublesTravauxSearchHelper(DvbTaxSession session) {
        this.session = session;
    }

    public void setNewTravauxCategory(String callerDmk, String selectedItem) {
        ModelItemDTO newCategorieDTO;
        String[] categorieCodes = selectedItem.split("\\.");
        HashMap<CallSite, ModelItemDTO> newModelValue = new HashMap<CallSite, ModelItemDTO>();
        Map model = this.session.getDataModel();
        String categorieCode = categorieCodes[0];
        String categorieDMK = callerDmk + ".TravauxCategorie";
        ModelItemDTO categorieDTO = (ModelItemDTO)model.get(categorieDMK);
        if (categorieDTO != null) {
            newCategorieDTO = categorieDTO.clone((Object)categorieCode);
        } else {
            newCategorieDTO = new ModelItemDTO((Object)categorieCode, 1);
            newCategorieDTO.setTouched();
        }
        newModelValue.put((CallSite)((Object)categorieDMK), newCategorieDTO);
        this.session.update(newModelValue, true);
    }

    public static Map<String, TravauxImmeublesDTO> filteredTravaux(String searchText, Map<String, TravauxImmeublesDTO> fullTravauxMap) {
        HashMap<String, TravauxImmeublesDTO> filteredMap = new HashMap<String, TravauxImmeublesDTO>();
        for (Map.Entry<String, TravauxImmeublesDTO> dto : fullTravauxMap.entrySet()) {
            if (!StringUtils.containsIgnoreCase((CharSequence)dto.getKey(), (CharSequence)searchText)) continue;
            filteredMap.put(dto.getKey(), dto.getValue());
        }
        return filteredMap;
    }

    public void setNewSousCategory(String callerDmk, TravauxImmeublesDTO selectedItem) {
        String travauxDetailCode = selectedItem.getValue().toString();
        String[] categorieCode = travauxDetailCode.split("\\.");
        HashMap<CallSite, ModelItemDTO> newModelValue = new HashMap<CallSite, ModelItemDTO>();
        if (categorieCode.length > 1) {
            ModelItemDTO newSousCategorieDTO;
            String sousCategorieDMK = callerDmk + ".TravauxSousCategorie";
            Map model = this.session.getDataModel();
            ModelItemDTO sousCategorieDTO = (ModelItemDTO)model.get(sousCategorieDMK);
            String sousCategorieCode = categorieCode[0] + "." + categorieCode[1];
            if (sousCategorieDTO != null) {
                newSousCategorieDTO = sousCategorieDTO.clone((Object)sousCategorieCode);
            } else {
                newSousCategorieDTO = new ModelItemDTO((Object)sousCategorieCode, 1);
                newSousCategorieDTO.setTouched();
            }
            newModelValue.put((CallSite)((Object)sousCategorieDMK), newSousCategorieDTO);
        }
        this.session.update(newModelValue, true);
    }

    public void setNewDetailCategory(String callerDmk, TravauxImmeublesDTO selectedItem) {
        ModelItemDTO newDetailCategorieDTO;
        String travauxDetailCode = selectedItem.getValue().toString();
        HashMap<CallSite, ModelItemDTO> newModelValue = new HashMap<CallSite, ModelItemDTO>();
        String detailCategoryDMK = callerDmk + ".TravauxDetail";
        Map model = this.session.getDataModel();
        ModelItemDTO detailCategorieDTO = null;
        if (model != null) {
            detailCategorieDTO = (ModelItemDTO)model.get(detailCategoryDMK);
        }
        if (detailCategorieDTO != null) {
            newDetailCategorieDTO = detailCategorieDTO.clone((Object)travauxDetailCode);
        } else {
            newDetailCategorieDTO = new ModelItemDTO((Object)travauxDetailCode, 1);
            newDetailCategorieDTO.setTouched();
        }
        newModelValue.put((CallSite)((Object)detailCategoryDMK), newDetailCategorieDTO);
        this.session.update(newModelValue, true);
    }
}

