/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.utils;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.ge.pp.utils.InternalFailureException;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.text.MessageFormat;

public final class ErrorCode
extends Enum<ErrorCode> {
    public static final /* enum */ ErrorCode GENERIC = new ErrorCode("0000", "label.error.generic");
    public static final /* enum */ ErrorCode PORTAL_INTERFACING = new ErrorCode("2000", "label.error.portal");
    public static final /* enum */ ErrorCode MISSING_OR_INVALID_PARAMETER = new ErrorCode("2001", "label.error.portal.param");
    public static final /* enum */ ErrorCode DATA_MISMATCH = new ErrorCode("2002", "label.error.portal.mismatch");
    public static final /* enum */ ErrorCode UNEXISTING_CASE = new ErrorCode("2003", "label.error.portal.nosuchcase");
    public static final /* enum */ ErrorCode CASE_ALREADY_EXISTS = new ErrorCode("2005", "label.error.portal.caseexist");
    public static final /* enum */ ErrorCode AUTHENTICATION = new ErrorCode("3000", "label.error.auth");
    public static final /* enum */ ErrorCode AUTHENTICATION_REQUIRED = new ErrorCode("3001", "label.error.auth.required");
    public static final /* enum */ ErrorCode EXPIRED_VIEW = new ErrorCode("3002", "label.error.auth.expired");
    public static final /* enum */ ErrorCode CONCURRENT_ACCESS = new ErrorCode("3003", "label.error.auth.concurrentaccess");
    public static final /* enum */ ErrorCode BACKEND = new ErrorCode("4000", "label.error.backend");
    public static final /* enum */ ErrorCode NO_BACKEND = new ErrorCode("4001", "label.error.backend.nobackend");
    public static final /* enum */ ErrorCode BACKEND_LOGIN = new ErrorCode("4002", "label.error.backend.login");
    public static final /* enum */ ErrorCode BACKEND_SUBMISSION = new ErrorCode("4003", "label.error.backend.release");
    public static final /* enum */ ErrorCode BACKEND_MISC = new ErrorCode("4004", "label.error.backend.misc");
    public static final /* enum */ ErrorCode ENVIRONMENT = new ErrorCode("5000", "label.error.env");
    public static final /* enum */ ErrorCode DATABASE = new ErrorCode("5001", "label.error.env.database");
    public static final /* enum */ ErrorCode CONFIGURATION = new ErrorCode("5003", "label.error.env.configuration");
    public static final /* enum */ ErrorCode INTERNAL = new ErrorCode("9000", "label.error.internal");
    private static final String FORMAT_STRING = "[{0}] - {1}";
    private final String code;
    private final String labelKey;
    private static final /* synthetic */ ErrorCode[] $VALUES;

    public static ErrorCode[] values() {
        return (ErrorCode[])$VALUES.clone();
    }

    public static ErrorCode valueOf(String name) {
        return Enum.valueOf(ErrorCode.class, name);
    }

    private ErrorCode(String code, String labelKey) {
        assert (code != null && labelKey != null);
        this.code = code;
        this.labelKey = labelKey;
    }

    public String code() {
        return this.code;
    }

    public String labelKey() {
        return this.labelKey;
    }

    public String format(Object ... arguments) {
        try {
            String msg = SharedUtils.translate(this.labelKey, arguments);
            return MessageFormat.format(FORMAT_STRING, this.code, msg);
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new InternalFailureException("Failed to translate message string", e);
        }
    }

    private static /* synthetic */ ErrorCode[] $values() {
        return new ErrorCode[]{GENERIC, PORTAL_INTERFACING, MISSING_OR_INVALID_PARAMETER, DATA_MISMATCH, UNEXISTING_CASE, CASE_ALREADY_EXISTS, AUTHENTICATION, AUTHENTICATION_REQUIRED, EXPIRED_VIEW, CONCURRENT_ACCESS, BACKEND, NO_BACKEND, BACKEND_LOGIN, BACKEND_SUBMISSION, BACKEND_MISC, ENVIRONMENT, DATABASE, CONFIGURATION, INTERNAL};
    }

    static {
        $VALUES = ErrorCode.$values();
    }
}

