/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.utils;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class DataModelUtil {
    private static final Number ZERO = 0;
    private LogicModelItem.ProtectedMap dataModel = null;

    public DataModelUtil(LogicModelItem.ProtectedMap dataModel) {
        this.dataModel = dataModel;
    }

    public Object getValue(String dmk) {
        return this.get(dmk, Object.class, null);
    }

    public String getString(String dmk) {
        return this.get(dmk, String.class, null);
    }

    public Set<Object> getTableRowIndexes(String dmk) {
        AbstractSet result;
        Collection indexes = (Collection)this.getValue(dmk);
        if (indexes == null || indexes.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            result = new TreeSet<Object>(indexes);
        }
        catch (ClassCastException e) {
            result = new HashSet(indexes);
        }
        return result;
    }

    public double getDouble(String dmk) {
        return this.getNumber(dmk).doubleValue();
    }

    public long getLong(String dmk) {
        return this.getNumber(dmk).longValue();
    }

    public Long getLongObject(String dmk) {
        Number value = this.getNumber(dmk, null);
        return value != null ? Long.valueOf(value.longValue()) : null;
    }

    public Number getNumber(String dmk) {
        return this.getNumber(dmk, ZERO);
    }

    public Number getNumber(String dmk, Number defaultValue) {
        return this.get(dmk, Number.class, defaultValue);
    }

    public boolean getBoolean(String dmk) {
        return this.get(dmk, Boolean.class, Boolean.FALSE);
    }

    public Boolean getBooleanObject(String dmk) {
        return this.get(dmk, Boolean.class, null);
    }

    public <T> T get(String dmk, Class<T> type, T defaultValue) {
        if (dmk == null || type == null) {
            throw new NullPointerException();
        }
        ModelItemDTO item = this.dataModel.get((Object)dmk);
        if (item == null) {
            return defaultValue;
        }
        Object obj = item.getValue();
        if (obj == null) {
            return defaultValue;
        }
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException("Wrong element type, expected: " + type.getCanonicalName() + " got: " + obj.getClass().getCanonicalName());
        }
        return type.cast(obj);
    }
}

