/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.utils;

import java.io.IOException;
import java.io.Writer;
import java.text.Normalizer;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class UTF8NormalizingWriter
extends Writer {
    private final @NonNull Writer writer;

    public UTF8NormalizingWriter(@NonNull Writer writer) {
        this.writer = Objects.requireNonNull(writer);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Objects.requireNonNull(cbuf);
        String normalized = Normalizer.normalize(new String(cbuf, off, len), Normalizer.Form.NFC);
        this.writer.append(normalized);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

