/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.utils;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.PersistenceReadDTO;
import ch.dvbern.tax.ge.pp.engine.dto.PKey;
import ch.dvbern.tax.ge.pp.engine.dto.PKeyTemplate;
import ch.dvbern.tax.ge.pp.engine.dto.PKeyTuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceKeysRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceKeysRegistry.class);
    private final Map<String, PKeyToDmkTokens> pKeyToDmkTokensByLMKMap;
    private final Map<PKeyTuple, PKeyToDmkTokens> pKeyToDmkModelsByTuple;
    private final Map<LmkQueryKey, String> lmkQueryMap;
    private final Map<String, List<String>> tablesIdsByLegacyTuple;

    private PersistenceKeysRegistry(Map<String, PKeyToDmkTokens> templatesByLMKMap, Map<PKeyTuple, PKeyToDmkTokens> templatesByTuple, Map<LmkQueryKey, String> lmkQueryMap, Map<String, List<String>> tablesIdsByLegacyTuple) {
        assert (templatesByLMKMap != null && templatesByTuple != null && tablesIdsByLegacyTuple != null && lmkQueryMap != null);
        this.pKeyToDmkTokensByLMKMap = templatesByLMKMap;
        this.pKeyToDmkModelsByTuple = templatesByTuple;
        this.lmkQueryMap = lmkQueryMap;
        this.tablesIdsByLegacyTuple = tablesIdsByLegacyTuple;
    }

    @Nullable
    public PKeyTemplate getTemplateForTuple(@Nonnull PKeyTuple pKeyTuple) {
        if (pKeyTuple == null) {
            throw new NullPointerException("PKey tuple cannot be null.");
        }
        PKeyToDmkTokens templates = this.pKeyToDmkModelsByTuple.get(pKeyTuple);
        return templates != null ? templates.pKeyTemplate : null;
    }

    @Nullable
    public List<String> getDMKTemplateForTuple(@Nonnull PKeyTuple pKeyTuple) {
        if (pKeyTuple == null) {
            throw new NullPointerException("PKey tuple cannot be null.");
        }
        PKeyToDmkTokens templates = this.pKeyToDmkModelsByTuple.get(pKeyTuple);
        return templates != null ? templates.dmkTokens : null;
    }

    @Nullable
    public String getTableLMK(@Nonnull String formId, @Nonnull List<String> tablesIds) {
        if (formId == null) {
            throw new NullPointerException("Form id cannot be null.");
        }
        if (tablesIds == null) {
            throw new NullPointerException("Table ids list cannot be null.");
        }
        return this.lmkQueryMap.get(new LmkQueryKey(formId, tablesIds));
    }

    @Nonnull
    public Map<PKey, Object> buildPersistenceMap(@Nonnull Map<String, ModelItemDTO> updateMap) {
        if (updateMap == null) {
            throw new NullPointerException("The update map cannot be null.");
        }
        HashMap<PKey, Object> valueMap = new HashMap<PKey, Object>(100);
        HashMap<String, List<String>> rowDMKToTableIdsMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, ModelItemDTO> updateMapEntry : updateMap.entrySet()) {
            String dmk;
            String lmk;
            PKeyToDmkTokens pKeyToDatamodelKeys;
            ModelItemDTO updateModelItem = updateMapEntry.getValue();
            Object value = updateModelItem != null ? updateModelItem.getValue() : null;
            if (value == null || (pKeyToDatamodelKeys = this.pKeyToDmkTokensByLMKMap.get(lmk = EngineUtil.removeTableIndices((String)(dmk = updateMapEntry.getKey())))) == null) continue;
            ArrayList<Integer> indexes = new ArrayList<Integer>(2);
            List<String> dmkTokens = pKeyToDatamodelKeys.dmkTokens;
            int dmkOffset = 0;
            for (int i = 1; i < dmkTokens.size(); ++i) {
                int index = i - 1;
                int indexStartAt = dmkOffset += dmkTokens.get(index).length();
                int indexEndAt = dmk.indexOf(46, indexStartAt);
                if (indexEndAt == -1) {
                    throw new IllegalArgumentException("Invalid data model key: " + dmk);
                }
                String indexStr = dmk.substring(indexStartAt, indexEndAt);
                dmkOffset += indexStr.length();
                try {
                    indexes.add(Integer.valueOf(indexStr));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Incompatible DMK found: %s, for template: %s", dmk, dmkTokens));
                }
            }
            if (dmkTokens.size() > 1) {
                List<String> tableIds;
                String rowDmk = dmk.substring(0, dmkOffset);
                if (rowDmk.startsWith("Titres.Divers.DiversTable.")) {
                    rowDmk = dmk;
                }
                if ((tableIds = rowDMKToTableIdsMap.put(rowDmk, pKeyToDatamodelKeys.pKeyTemplate.pkTuple.tableIds)) != null && !tableIds.equals(pKeyToDatamodelKeys.pKeyTemplate.pkTuple.tableIds)) {
                    throw new IllegalArgumentException(String.format("The provided data model resulted in persistence items from the same table entry to be stored in multiple table IDs. Table entry: %s, table IDs 1: %s, table IDs 2: %s", dmk, pKeyToDatamodelKeys.pKeyTemplate.pkTuple.tableIds, tableIds));
                }
            }
            PKey pKey = pKeyToDatamodelKeys.pKeyTemplate.generatePKey(indexes);
            valueMap.put(pKey, updateModelItem != null ? updateModelItem.getValue() : null);
        }
        return valueMap;
    }

    @Nonnull
    public Map<String, ModelItemDTO> buildUpdateMap(@Nonnull Map<PKey, Object> persistedValues) throws ImportException {
        if (persistedValues == null) {
            throw new NullPointerException("Persisted values map cannot be null.");
        }
        HashMap<String, ModelItemDTO> updateMap = new HashMap<String, ModelItemDTO>(persistedValues.size());
        for (Map.Entry<PKey, Object> persistedValue : persistedValues.entrySet()) {
            Object dmk;
            boolean ok;
            PKey pKey = persistedValue.getKey();
            List<String> dmkTokens = this.pKeyToDmkModelsByTuple.get((Object)pKey.pkTuple).dmkTokens;
            if (dmkTokens == null) {
                LOG.debug("Ignoring persisted value with unknown mapping: {}", (Object)pKey);
                continue;
            }
            int lnDokument = pKey.getLnDokument();
            int lnZelle = pKey.getLnZelle();
            switch (dmkTokens.size()) {
                case 1: {
                    ok = lnDokument == 0 && lnZelle == 0;
                    dmk = dmkTokens.get(0);
                    break;
                }
                case 2: {
                    ok = lnDokument > 0 ^ lnZelle > 0;
                    dmk = dmkTokens.get(0) + (lnDokument > 0 ? lnDokument : lnZelle) + dmkTokens.get(1);
                    break;
                }
                case 3: {
                    ok = lnDokument > 0 && lnZelle > 0;
                    dmk = dmkTokens.get(0) + lnDokument + dmkTokens.get(1) + lnZelle + dmkTokens.get(2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Failed to parse dmk template '%s'.", dmkTokens));
                }
            }
            if (!ok) {
                LOG.error("Skipping inconsistent entry {} for dmk template: {}.", (Object)pKey, dmkTokens);
                continue;
            }
            ModelItemDTO item = new ModelItemDTO(persistedValue.getValue());
            item.setTouched();
            updateMap.put((String)dmk, item);
        }
        return updateMap;
    }

    @Nonnull
    public static PersistenceKeysRegistry newInstance(@Nonnull List<PersistenceReadDTO> pReadsDTOs) {
        if (pReadsDTOs == null) {
            throw new NullPointerException("List of persistence-reads cannot be null.");
        }
        HashMap<String, PKeyToDmkTokens> templatesByLMKMap = new HashMap<String, PKeyToDmkTokens>(pReadsDTOs.size());
        HashMap<PKeyTuple, PKeyToDmkTokens> templatesByTupleMap = new HashMap<PKeyTuple, PKeyToDmkTokens>(pReadsDTOs.size());
        HashMap<LmkQueryKey, String> lmkQueryMap = new HashMap<LmkQueryKey, String>();
        HashMap<String, List<String>> tablesIdsByLegacyTuple = new HashMap<String, List<String>>(pReadsDTOs.size());
        for (PersistenceReadDTO pReadDTO : pReadsDTOs) {
            String dmkTemplateString = pReadDTO.getDataModelKeyTemplate();
            String lmk = pReadDTO.getDataModelKeyTemplate().replace(".#", "");
            PKeyTemplate pKeyTemplate = PKeyTemplate.parse(pReadDTO.getPersistenceKeyTemplate());
            Object[] dmkTemplate = dmkTemplateString.split("#");
            if (dmkTemplate.length - 1 != pKeyTemplate.pkTuple.tableIds.size()) {
                throw new IllegalArgumentException(String.format("Incompatible table depths:  DMK template = %s - pKey template = %s", Arrays.toString(dmkTemplate), pKeyTemplate));
            }
            PKeyToDmkTokens templates = new PKeyToDmkTokens(pKeyTemplate, (String[])dmkTemplate);
            if (dmkTemplate.length > 1) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < dmkTemplate.length - 1; ++i) {
                    Object token = dmkTemplate[i];
                    int start = ((String)token).startsWith(".") ? 1 : 0;
                    sb.append((CharSequence)token, start, ((String)token).length());
                    String tableLMK = sb.toString();
                    String previous = lmkQueryMap.put(new LmkQueryKey(pKeyTemplate.pkTuple.dokument, pKeyTemplate.pkTuple.tableIds.subList(0, i + 1)), tableLMK);
                    if (previous == null || previous.equals(tableLMK)) continue;
                    throw new IllegalArgumentException(String.format("Template %s was mapped to multiple table: %s and %s.", pKeyTemplate, tableLMK, previous));
                }
            }
            templatesByLMKMap.put(lmk, templates);
            templatesByTupleMap.put(pKeyTemplate.pkTuple, templates);
            tablesIdsByLegacyTuple.put(pKeyTemplate.pkTuple.dokument + "-" + pKeyTemplate.pkTuple.ziffer + "-" + pKeyTemplate.pkTuple.zelle, pKeyTemplate.pkTuple.tableIds);
        }
        return new PersistenceKeysRegistry(templatesByLMKMap, templatesByTupleMap, lmkQueryMap, tablesIdsByLegacyTuple);
    }

    private static class PKeyToDmkTokens {
        final PKeyTemplate pKeyTemplate;
        final List<String> dmkTokens;

        PKeyToDmkTokens(PKeyTemplate pKeyTemplate, String[] dmkTemplate) {
            this.pKeyTemplate = pKeyTemplate;
            this.dmkTokens = Collections.unmodifiableList(Arrays.asList(dmkTemplate));
        }
    }

    private static class LmkQueryKey {
        final String formId;
        final List<String> tableIds;
        final int hashcode;

        LmkQueryKey(String formId, List<String> tableIds) {
            assert (formId != null && tableIds != null);
            this.formId = formId;
            this.tableIds = tableIds;
            this.hashcode = new HashCodeBuilder(1817424871, 1776666239).append((Object)formId).append(tableIds).build();
        }

        public boolean equals(Object obj) {
            if (obj instanceof LmkQueryKey) {
                LmkQueryKey that = (LmkQueryKey)obj;
                return this.hashcode == that.hashcode && this.formId.equals(that.formId) && this.tableIds.equals(that.tableIds);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    private static class TableModel {
        private int currentIndex = 1;
        private Map<String, TableModel> childrenIndexes = new HashMap<String, TableModel>();

        private TableModel() {
        }
    }
}

