/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.utils;

import ch.dvbern.tax.ge.pp.transfer.utils.PersonneAChargeConst;
import ch.dvbern.tax.ge.pp.transfer.utils.PersonneAChargeEnums;

public class DeductionPersChargeUtils {
    public static long determineBaremeICCasNr(String baremeICC) {
        return "Splitting".equals(baremeICC) ? 1L : 0L;
    }

    public static long computeBaremeIFDAsNumber(String baremeIFD) {
        return baremeIFD != null && baremeIFD.equals("Mari\u00e9") ? 1L : 0L;
    }

    public static int calculalteDeductionEntiere(double chargeICC) {
        if (DeductionPersChargeUtils.isDouble1EqualsToDouble2(chargeICC, 1.0)) {
            return 1;
        }
        return 0;
    }

    public static int calculalteDeductionDemi(double chargeICC) {
        if (DeductionPersChargeUtils.isDouble1EqualsToDouble2(chargeICC, 0.5)) {
            return 1;
        }
        return 0;
    }

    private static boolean isDouble1EqualsToDouble2(double d1, double d2) {
        double epsilon = 1.0E-6;
        return Math.abs(d1 - d2) < epsilon;
    }

    public static double determineChargeICC1RevenuFortune(long revenu, long fortune) {
        if (revenu <= PersonneAChargeConst.REVENU_TRANCHE_1 && fortune <= PersonneAChargeConst.FORTUNE_TRANCHE_1) {
            return PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue;
        }
        if (revenu > PersonneAChargeConst.REVENU_TRANCHE_1 && revenu <= PersonneAChargeConst.REVENU_TRANCHE_2 && fortune <= PersonneAChargeConst.FORTUNE_TRANCHE_1) {
            return PersonneAChargeEnums.ChargeICC.DEMI_CHARGE.doubleValue;
        }
        return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
    }
}

