/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.utils;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.common.util.XMLCodePointFilter;
import ch.dvbern.tax.ge.pp.engine.dto.PKeyType;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarcodeValueMarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(BarcodeValueMarshaller.class);
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
            fmt.setTimeZone(ApplicationConfig.TIMEZONE);
            return fmt;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> DATE_YEAR_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy");
            fmt.setTimeZone(ApplicationConfig.TIMEZONE);
            return fmt;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> DATE_MONTH_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat fmt = new SimpleDateFormat("ddMM");
            fmt.setTimeZone(ApplicationConfig.TIMEZONE);
            return fmt;
        }
    };
    private static final ThreadLocalFloatFormat FLOAT_FORMAT = new ThreadLocalFloatFormat(0);
    private static final ThreadLocalFloatFormat FLOAT_FORMAT_1 = new ThreadLocalFloatFormat(1);
    private static final ThreadLocalFloatFormat FLOAT_FORMAT_2 = new ThreadLocalFloatFormat(2);
    private static final ThreadLocalFloatFormat FLOAT_FORMAT_3 = new ThreadLocalFloatFormat(3);

    public final String marshall(Object value, PKeyType type) {
        block2: {
            try {
                this.checkValue(value, type);
            }
            catch (IllegalArgumentException e) {
                String msg = "Model value does not match its expected type.";
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Model value does not match its expected type.");
            }
        }
        return this.marshallDelegate(value, type);
    }

    public final Serializable unMarshall(String value, PKeyType type) {
        Serializable result = this.unMarshallDelegate(value, type);
        this.checkValue(result, type);
        return result;
    }

    private void checkValue(Object value, PKeyType type) {
        if (value != null && !type.getTargetType().isInstance(value)) {
            throw new IllegalArgumentException("Failure: " + String.valueOf(value.getClass()) + " cannot be cast to " + String.valueOf(type.getTargetType()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private String marshallDelegate(Object value, PKeyType type) {
        if (value == null) {
            return "";
        }
        switch (4.$SwitchMap$ch$dvbern$tax$ge$pp$engine$dto$PKeyType[type.ordinal()]) {
            default: {
                msg = "Unknown barcode type: " + String.valueOf((Object)type) + "(" + type.getIdentifier() + ")";
                if (!BarcodeValueMarshaller.$assertionsDisabled) {
                    throw new AssertionError((Object)msg);
                }
                BarcodeValueMarshaller.LOG.error(msg);
            }
            case 1: 
            case 2: {
                return new XMLCodePointFilter().translate((CharSequence)value.toString());
            }
            case 3: 
            case 4: {
                return value.toString();
            }
            case 5: {
                return ((DecimalFormat)BarcodeValueMarshaller.FLOAT_FORMAT.get()).format(((Number)value).doubleValue());
            }
            case 6: {
                return ((DecimalFormat)BarcodeValueMarshaller.FLOAT_FORMAT_1.get()).format(((Number)value).doubleValue());
            }
            case 7: {
                return ((DecimalFormat)BarcodeValueMarshaller.FLOAT_FORMAT_2.get()).format(((Number)value).doubleValue());
            }
            case 8: {
                return ((DecimalFormat)BarcodeValueMarshaller.FLOAT_FORMAT_3.get()).format(((Number)value).doubleValue());
            }
            case 9: {
                valueName = value.getClass().getSimpleName();
                if (valueName.equals(Date.class.getSimpleName())) {
                    return BarcodeValueMarshaller.DATE_FORMAT.get().format((Date)value);
                }
                if (!valueName.equals(LocalDate.class.getSimpleName())) ** GOTO lbl34
                fmt = new SimpleDateFormat("yyyy-MM-dd");
                fmt.setTimeZone(ApplicationConfig.TIMEZONE);
                try {
                    date = fmt.parse(value.toString());
                    return BarcodeValueMarshaller.DATE_FORMAT.get().format(date);
                }
                catch (ParseException e) {
                    BarcodeValueMarshaller.LOG.error("Could not parse date", (Throwable)e);
                    ** GOTO lbl42
                }
lbl34:
                // 1 sources

                if (valueName.equals(LocalDateTime.class.getSimpleName())) {
                    fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    fmt.setTimeZone(ApplicationConfig.TIMEZONE);
                    try {
                        date = fmt.parse(value.toString());
                        return BarcodeValueMarshaller.DATE_FORMAT.get().format(date);
                    }
                    catch (ParseException e) {
                        BarcodeValueMarshaller.LOG.error("Could not parse date", (Throwable)e);
                    }
                }
            }
lbl42:
            // 5 sources

            case 10: {
                valueNam = value.getClass().getSimpleName();
                if (valueNam.equals(Date.class.getSimpleName())) {
                    return BarcodeValueMarshaller.DATE_MONTH_FORMAT.get().format((Date)value);
                }
                if (valueNam.equals(LocalDate.class.getSimpleName())) {
                    fmt = new SimpleDateFormat("yyyy-MM-dd");
                    fmt.setTimeZone(ApplicationConfig.TIMEZONE);
                    try {
                        date = fmt.parse(value.toString());
                        return BarcodeValueMarshaller.DATE_MONTH_FORMAT.get().format(date);
                    }
                    catch (ParseException e) {
                        BarcodeValueMarshaller.LOG.error("Could not parse date", (Throwable)e);
                        break;
                    }
                }
                if (!valueNam.equals(LocalDateTime.class.getSimpleName())) break;
                fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                fmt.setTimeZone(ApplicationConfig.TIMEZONE);
                try {
                    date = fmt.parse(value.toString());
                    return BarcodeValueMarshaller.DATE_MONTH_FORMAT.get().format(date);
                }
                catch (ParseException e) {
                    BarcodeValueMarshaller.LOG.error("Could not parse date", (Throwable)e);
                }
            }
            case 11: 
        }
        return value.toString();
    }

    private Serializable unMarshallDelegate(String value, PKeyType type) {
        Object result;
        if (value == null) {
            return null;
        }
        switch (type) {
            case STRING: {
                result = value;
                break;
            }
            case NUMBER: {
                try {
                    result = new BigDecimal(value).longValue();
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Cannot be represented as an integer: " + value, e);
                }
            }
            case BOOLEAN: {
                result = Boolean.valueOf(value);
                break;
            }
            case FLOAT: 
            case FLOAT1: 
            case FLOAT2: 
            case FLOAT3: {
                try {
                    result = new BigDecimal(value).doubleValue();
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Cannot be represented as double: " + value, e);
                }
            }
            case DATE: {
                try {
                    result = DATE_FORMAT.get().parse(value);
                    break;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Cannot be represented as date-month: " + value, e);
                }
            }
            case DATE_MONTH: {
                try {
                    result = DATE_MONTH_FORMAT.get().parse(value);
                    break;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Cannot be represented as date-month: " + value, e);
                }
            }
            case DATE_YEAR: {
                try {
                    Date date = DATE_YEAR_FORMAT.get().parse(value);
                    Calendar cal = Calendar.getInstance(GeConstants.DEFAULT_LOCALE);
                    cal.setTimeZone(ApplicationConfig.TIMEZONE);
                    cal.setTime(date);
                    result = (long)cal.get(1);
                    break;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Cannot be represented as date-year: " + value, e);
                }
            }
            default: {
                String msg = "Unknown barcode type: " + String.valueOf((Object)type) + " (" + type.getIdentifier() + ")";
                assert (false) : msg;
                LOG.error(msg);
            }
            case OTHER: {
                result = null;
            }
        }
        return result;
    }

    private static class ThreadLocalFloatFormat
    extends ThreadLocal<DecimalFormat> {
        private final String formatString;

        public ThreadLocalFloatFormat(int decimal) {
            assert (decimal >= 0);
            StringBuilder buf = new StringBuilder("0.");
            for (int i = 0; i < decimal; ++i) {
                buf.append('0');
            }
            this.formatString = buf.toString();
        }

        @Override
        protected DecimalFormat initialValue() {
            DecimalFormat df = new DecimalFormat(this.formatString);
            DecimalFormatSymbols symbol = new DecimalFormatSymbols(GeConstants.DEFAULT_LOCALE);
            symbol.setDecimalSeparator('.');
            df.setDecimalFormatSymbols(symbol);
            return df;
        }
    }
}

