/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.logic;

import ch.dvbern.tax.ge.pp.transfer.dto.DeducPersChargeDTO;
import ch.dvbern.tax.ge.pp.transfer.utils.DeductionPersChargeUtils;
import ch.dvbern.tax.ge.pp.transfer.utils.PersonneAChargeConst;
import ch.dvbern.tax.ge.pp.transfer.utils.PersonneAChargeEnums;
import java.util.HashMap;
import java.util.Map;

public class DeductionPersonneAChargeUtils
extends DeductionPersChargeUtils {
    public static Map<String, Object> createMapFromDeduction(DeducPersChargeDTO deducPersChargeDTO) {
        HashMap<String, Object> deductionMap = new HashMap<String, Object>(3);
        deductionMap.put(PersonneAChargeConst.BAREM_ICC, deducPersChargeDTO.getBaremeICC());
        deductionMap.put(PersonneAChargeConst.BAREM_IFD, deducPersChargeDTO.getBaremeIFD());
        deductionMap.put(PersonneAChargeConst.CHARGE_ICC, deducPersChargeDTO.getChargeICC());
        deductionMap.put(PersonneAChargeConst.CHARGE_IFD, deducPersChargeDTO.getChargeIFD());
        deductionMap.put(PersonneAChargeConst.DED_6125_CFICC, deducPersChargeDTO.getDed6125CFICC());
        deductionMap.put(PersonneAChargeConst.DED_5215_ICC, deducPersChargeDTO.getDedPlafondAssuranceVie5215ICC());
        deductionMap.put(PersonneAChargeConst.DED_5150_ICC, deducPersChargeDTO.getDedSocialeFortune5150ICC());
        deductionMap.put(PersonneAChargeConst.DED_6120_IFD, deducPersChargeDTO.getDed6120IFD());
        deductionMap.put(PersonneAChargeConst.DED_5200_IFD, deducPersChargeDTO.getDedPlafondAssuranceVie5200IFD());
        deductionMap.put(PersonneAChargeConst.REDUCTION_POUR_BAREME_PARENTAL, deducPersChargeDTO.getReducPourBaremeParental());
        deductionMap.put(PersonneAChargeConst.NOMBRE_DEDUCTION_ENTIERE, deducPersChargeDTO.getNombreDeductionEntiere());
        deductionMap.put(PersonneAChargeConst.NOMBRE_DEMI_DEDUCTION, deducPersChargeDTO.getNombreDemiDeduction());
        return deductionMap;
    }

    public static DeducPersChargeDTO createDeducPersChargeDTOFromMap(Map<?, ?> data) {
        DeducPersChargeDTO deducPersChargeDTO;
        if (data == null) {
            deducPersChargeDTO = DeductionPersonneAChargeUtils.createNewDeductionDTOWithDefaultValue();
        } else {
            Object baremeICCObject = data.get(PersonneAChargeConst.BAREM_ICC);
            Object baremeIFDObject = data.get(PersonneAChargeConst.BAREM_IFD);
            Object chargeICCObject = data.get(PersonneAChargeConst.CHARGE_ICC);
            Object chargeIFDObject = data.get(PersonneAChargeConst.CHARGE_IFD);
            Object ded6125CFICCObject = data.get(PersonneAChargeConst.DED_6125_CFICC);
            Object ded5215PlafondAssuranceVieICCObject = data.get(PersonneAChargeConst.DED_5215_ICC);
            Object ded5150SocialeFortuneICCObject = data.get(PersonneAChargeConst.DED_5150_ICC);
            Object ded6120IFDObject = data.get(PersonneAChargeConst.DED_6120_IFD);
            Object dedPlafondAssuranceVie5200IFDObject = data.get(PersonneAChargeConst.DED_5200_IFD);
            Object reducPourBaremeParentalObject = data.get(PersonneAChargeConst.REDUCTION_POUR_BAREME_PARENTAL);
            Object nombreDeductionEntiereObject = data.get(PersonneAChargeConst.NOMBRE_DEDUCTION_ENTIERE);
            Object nombreDemiDeductionObject = data.get(PersonneAChargeConst.NOMBRE_DEMI_DEDUCTION);
            String baremICC = baremeICCObject != null ? (String)baremeICCObject : "Sans splitting";
            String baremIFD = baremeIFDObject != null ? (String)baremeIFDObject : "C\u00e9libataire";
            double chargeICC = chargeICCObject != null ? (Double)chargeICCObject : PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
            double chargeIFD = chargeIFDObject != null ? (Double)chargeIFDObject : PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
            long ded6125CFICC = DeductionPersonneAChargeUtils.convertObjectToLong(ded6125CFICCObject, 0L);
            long ded5215PlafondAssuranceVieICC = DeductionPersonneAChargeUtils.convertObjectToLong(ded5215PlafondAssuranceVieICCObject, 0L);
            long ded5150SocialeFortuneICC = DeductionPersonneAChargeUtils.convertObjectToLong(ded5150SocialeFortuneICCObject, 0L);
            long ded6120IFD = DeductionPersonneAChargeUtils.convertObjectToLong(ded6120IFDObject, 0L);
            long dedPlafondAssuranceVie5200IFD = DeductionPersonneAChargeUtils.convertObjectToLong(dedPlafondAssuranceVie5200IFDObject, 0L);
            long reducPourBaremeParental = DeductionPersonneAChargeUtils.convertObjectToLong(reducPourBaremeParentalObject, 0L);
            long nombreDeductionEntiere = DeductionPersonneAChargeUtils.convertObjectToLong(nombreDeductionEntiereObject, 0L);
            long nombreDemiDeduction = DeductionPersonneAChargeUtils.convertObjectToLong(nombreDemiDeductionObject, 0L);
            deducPersChargeDTO = new DeducPersChargeDTO(baremICC, baremIFD, chargeICC, chargeIFD, ded6125CFICC, ded5215PlafondAssuranceVieICC, ded5150SocialeFortuneICC, ded6120IFD, dedPlafondAssuranceVie5200IFD, reducPourBaremeParental, nombreDeductionEntiere, nombreDemiDeduction);
        }
        return deducPersChargeDTO;
    }

    private static long convertObjectToLong(Object object, long defaultValue) {
        if (object == null) {
            return defaultValue;
        }
        if (object instanceof Double) {
            double doubleObject = (Double)object;
            return (long)doubleObject;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        return defaultValue;
    }

    public static DeducPersChargeDTO createNewDeductionDTOWithDefaultValue() {
        return new DeducPersChargeDTO("Sans splitting", "C\u00e9libataire", PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue, PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }
}

