/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.logic;

import ch.dvbern.tax.ge.pp.transfer.dto.AutrePersonneAChargeDTO;
import ch.dvbern.tax.ge.pp.transfer.dto.DeducPersChargeDTO;
import ch.dvbern.tax.ge.pp.transfer.utils.DeductionPersChargeUtils;
import ch.dvbern.tax.ge.pp.transfer.utils.PersonneAChargeEnums;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class DeductionAutrePersonneAChargeUtils {
    public static DeducPersChargeDTO calculateDeductionForAutrePersACharge(AutrePersonneAChargeDTO autrePersChargeDTO) {
        String baremeIFD = DeductionAutrePersonneAChargeUtils.determineBaremeIFD(autrePersChargeDTO);
        double chargeICC1 = DeductionPersChargeUtils.determineChargeICC1RevenuFortune(autrePersChargeDTO.getRevenu(), autrePersChargeDTO.getFortune());
        double chargeICC2 = chargeICC1 > 0.0 ? DeductionAutrePersonneAChargeUtils.determineChargeICC(autrePersChargeDTO) : 0.0;
        double chargeICC = chargeICC1 * chargeICC2;
        String baremeICC = DeductionAutrePersonneAChargeUtils.determineBaremeICC(autrePersChargeDTO, chargeICC);
        double chargeIFD = DeductionAutrePersonneAChargeUtils.determineChargeIFD(autrePersChargeDTO);
        long ded6125CFICC = DeductionAutrePersonneAChargeUtils.determineDed6125CFICC(autrePersChargeDTO, chargeICC);
        long ded5215ICC = DeductionAutrePersonneAChargeUtils.compute5215ICC(chargeICC);
        long ded5150ICC = DeductionAutrePersonneAChargeUtils.compute5150ICC(chargeICC);
        long ded6120IFD = DeductionAutrePersonneAChargeUtils.compute6120IFD(chargeIFD);
        long ded5200IFD = DeductionAutrePersonneAChargeUtils.compute5200IFD(chargeIFD);
        long reducPourBaremeParental = DeductionAutrePersonneAChargeUtils.computeReducPourBaremeParentalIFD(autrePersChargeDTO, chargeIFD);
        long nombreDeductionEntiere = DeductionPersChargeUtils.calculalteDeductionEntiere(chargeICC);
        long nombreDemiDeduction = DeductionPersChargeUtils.calculalteDeductionDemi(chargeICC);
        return new DeducPersChargeDTO(baremeICC, baremeIFD, chargeICC, chargeIFD, ded6125CFICC, ded5215ICC, ded5150ICC, ded6120IFD, ded5200IFD, reducPourBaremeParental, nombreDeductionEntiere, nombreDemiDeduction);
    }

    private static String determineBaremeICC(AutrePersonneAChargeDTO autrePersChargeDTO, double chargeICC2) {
        if (autrePersChargeDTO.isMineur() && !autrePersChargeDTO.isResponsabilite()) {
            return "Sans splitting";
        }
        if (autrePersChargeDTO.isMajeur() && autrePersChargeDTO.getStatut() == PersonneAChargeEnums.Statut.OTHER_STATUT) {
            return "Sans splitting";
        }
        if (autrePersChargeDTO.getDegreDeParente() == PersonneAChargeEnums.DegreeDeParente.OTHER_DEGREE_DE_PARENTE) {
            return "Sans splitting";
        }
        if (autrePersChargeDTO.isVisAvec()) {
            return chargeICC2 > 0.0 ? "Splitting" : "Sans splitting";
        }
        return "Sans splitting";
    }

    private static String determineBaremeIFD(AutrePersonneAChargeDTO autrePersChargeDTO) {
        if (autrePersChargeDTO.isMineur() && !autrePersChargeDTO.isResponsabilite()) {
            return "C\u00e9libataire";
        }
        if (autrePersChargeDTO.isVisAvec()) {
            return "Mari\u00e9";
        }
        return "C\u00e9libataire";
    }

    private static double determineChargeICC(AutrePersonneAChargeDTO autrePersChargeDTO) {
        if (autrePersChargeDTO.isMineur() && !autrePersChargeDTO.isResponsabilite()) {
            return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
        }
        if (autrePersChargeDTO.getStatut() == PersonneAChargeEnums.Statut.OTHER_STATUT) {
            return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
        }
        if (autrePersChargeDTO.getDegreDeParente() == PersonneAChargeEnums.DegreeDeParente.OTHER_DEGREE_DE_PARENTE) {
            return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
        }
        if (autrePersChargeDTO.getNbrAutrePersonnesEntretient() > 0L) {
            double nbrChargeICC = 1.0 / (double)(1L + autrePersChargeDTO.getNbrAutrePersonnesEntretient());
            return DeductionAutrePersonneAChargeUtils.roundToTwoDecimals(nbrChargeICC);
        }
        return PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue;
    }

    private static long determineDed6125CFICC(AutrePersonneAChargeDTO autrePersChargeDTO, double nbrChargeICC) {
        if (autrePersChargeDTO.getDegreDeParente() == PersonneAChargeEnums.DegreeDeParente.OTHER_DEGREE_DE_PARENTE) {
            return 0L;
        }
        if (autrePersChargeDTO.isVisAvec()) {
            return Math.round(nbrChargeICC * 13660.0);
        }
        if (!autrePersChargeDTO.isVisAvec()) {
            long deduc6125ICC = Math.round(nbrChargeICC * 13660.0);
            return deduc6125ICC > autrePersChargeDTO.getPrestationVersee() ? autrePersChargeDTO.getPrestationVersee() : deduc6125ICC;
        }
        return 0L;
    }

    private static double determineChargeIFD(AutrePersonneAChargeDTO autrePersChargeDTO) {
        if (autrePersChargeDTO.isMineur() && !autrePersChargeDTO.isResponsabilite()) {
            return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
        }
        if (autrePersChargeDTO.isVisAvec()) {
            return PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue;
        }
        if (autrePersChargeDTO.getPrestationVersee() >= 6800L) {
            return PersonneAChargeEnums.ChargeICC.CHARGE_ENTIERE.doubleValue;
        }
        return PersonneAChargeEnums.ChargeICC.PAS_DE_CHAGE.doubleValue;
    }

    private static double roundToTwoDecimals(double value) {
        BigDecimal bigDecimal = BigDecimal.valueOf(value);
        bigDecimal = bigDecimal.setScale(2, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }

    private static long compute5215ICC(double chargeICC) {
        if (chargeICC <= 0.0) {
            return 0L;
        }
        return 959L;
    }

    private static long compute5150ICC(double chargeICC) {
        if (chargeICC <= 0.0) {
            return 0L;
        }
        return 43816L;
    }

    private static long compute6120IFD(double chargeIFD) {
        return Math.round(chargeIFD * 6800.0);
    }

    private static long compute5200IFD(double chargeIFD) {
        return Math.round(chargeIFD * 700.0);
    }

    private static long computeReducPourBaremeParentalIFD(AutrePersonneAChargeDTO autrePersChargeDTO, double chargeIFD) {
        if (chargeIFD > 0.0 && autrePersChargeDTO.isVisAvec()) {
            return 263L;
        }
        return 0L;
    }
}

