/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.TextConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StringMinMaxLengthConverter
extends TextConverter {
    private static final long serialVersionUID = 3763100777723475257L;
    private final Pattern pattern = Pattern.compile("[0-9a-zA-Z]*");
    private final int minLength;
    private String errorMax = "";
    private String errorMin = "";

    public StringMinMaxLengthConverter(int maxLength, int minLength) {
        super(maxLength);
        this.minLength = minLength;
        this.errorMax = Integer.toString(maxLength);
        this.errorMin = Integer.toString(minLength);
    }

    public String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        if (s.length() > this.maxLength) {
            throw new AbstractConverter.ConvertException("error.format.int-simple.max." + this.errorMax);
        }
        if (s.length() < this.minLength) {
            throw new AbstractConverter.ConvertException("error.format.int-simple.min." + this.errorMin);
        }
        Matcher m = this.pattern.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.int-simple");
        }
        return s;
    }

    public String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Float || o instanceof Double) {
            return Long.toString(Math.round(((Number)o).doubleValue()));
        }
        return o.toString();
    }

    @Nonnull
    public String getUserInputRegExpPattern() {
        return this.pattern.pattern();
    }
}

