/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CodeDeclarationConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 3258413941062578742L;
    private static final Pattern CODE_PTN = Pattern.compile("(\\d\\d)-?(\\d\\d\\d)-?(\\d\\d\\d) ?([A-Za-z]{3})?");

    public CodeDeclarationConverter() {
        super(String.class);
    }

    public @Nullable String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        String value = this.formatInput(s);
        if (value == null) {
            throw new AbstractConverter.ConvertException("error.format.codeDecla");
        }
        return value;
    }

    public String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        String input = o.toString();
        String renderedValue = this.formatInput(input);
        return renderedValue != null ? renderedValue : input;
    }

    private @Nullable String formatInput(@NonNull String input) {
        assert (input != null);
        Matcher m = CODE_PTN.matcher(input);
        if (m.matches()) {
            if (Integer.valueOf(m.group(1)) == 0 && Integer.valueOf(m.group(2)) == 0 && Integer.valueOf(m.group(3)) == 0) {
                return null;
            }
            if (m.group(4) != null) {
                return m.group(1) + "-" + m.group(2) + "-" + m.group(3) + " " + m.group(4).toUpperCase();
            }
            return m.group(1) + "-" + m.group(2) + "-" + m.group(3);
        }
        return null;
    }

    public @NonNull String getUserInputRegExpPattern() {
        return "[0-9]{1,2}\\-?[0-9]{0,3}\\-?[0-9]{0,3} ?[A-Za-z]{0,3}";
    }
}

