/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.dto;

import ch.dvbern.tax.common.integration.DvbTaxIdentification;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.ge.pp.transfer.dto.DossierMetaData;
import ch.dvbern.tax.ge.pp.transfer.dto.GeAuthenticationData;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeIdentificationDTO
implements DvbTaxIdentification {
    private static final Logger LOG = LoggerFactory.getLogger(GeIdentificationDTO.class);
    private static final long serialVersionUID = 1L;
    private final long taxFileId;
    private final GeAuthenticationData geAuthData;
    private final DossierMetaData dossierMetaData;
    private final long lock;
    private boolean touchModel = false;

    public GeIdentificationDTO(long taxFileId, GeAuthenticationData geAuthData, DossierMetaData dossierMetaData, long lock) {
        if (geAuthData == null) {
            throw new NullPointerException("Authentication data cannot be null.");
        }
        if (dossierMetaData == null) {
            throw new NullPointerException("Dossier meta data cannot be null.");
        }
        this.taxFileId = taxFileId;
        this.geAuthData = geAuthData;
        this.dossierMetaData = dossierMetaData;
        this.lock = lock;
    }

    public long getTaxFileId() {
        return this.taxFileId;
    }

    @Nonnull
    public GeAuthenticationData getGeAuthData() {
        return this.geAuthData;
    }

    @Nonnull
    public DossierMetaData getDossierMetaData() {
        return this.dossierMetaData;
    }

    public int getSteuerjahr() {
        return ApplicationConfig.getInstance().getJahr();
    }

    public long getLock() {
        return this.lock;
    }

    public boolean isDemoMode() {
        return ApplicationConfig.getInstance().getBoolean("demo.version", false);
    }

    public boolean isTouchModel() {
        return this.touchModel;
    }

    public void setTouchModel(boolean touchModel) {
        this.touchModel = touchModel;
    }

    public final String toString() {
        return new ToStringBuilder((Object)this).append("geAuthData", (Object)this.geAuthData).append("dossierMetaData", (Object)this.dossierMetaData).append("lock", this.lock).append("taxFileId", this.taxFileId).build();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

